//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_CONFIG_H)
    #define CANDERA_CONFIG_H

#include<FeatStd/Config.h>    


/// @addtogroup Config
/// @{

// -----------------------------------------------------------------------------
// Operating system defines
// -----------------------------------------------------------------------------
/** Operating system string, like Win32, Posix (aka. Linux), etc., to be used with FEATSTD_STRINGIZE(). */
#define CANDERA_OS Linux

/** Operating system define, denoting in the suffix the operating system chosen via CMAKE_SYSTEM_NAME. */
#define CANDERA_OS_LINUX

// -----------------------------------------------------------------------------
// Device defines based on FeatStd CMake properties
// -----------------------------------------------------------------------------

/** Device name string */
#define CANDERA_DEVICE Genivi

/** Device name system define, denoting in the suffix the device name chosen via CGIDEVICE_NAME. */
#define CANDERA_DEVICE_GENIVI 1

/** Device OpenGL ES version string */
#define CANDERA_DEVICE_GLES_VERSION 

// -----------------------------------------------------------------------------
// Feature defines based on CGI Studio CMake features
// -----------------------------------------------------------------------------
/// CANDERA_2D_ENABLED defines whether Candera2D sources shall be included or not.
#define CANDERA_2D_ENABLED

/// CANDERA_LAYOUT_ENABLED defines whether Candera dynamic layout is enabled or not.
#define CANDERA_LAYOUT_ENABLED

/// CANDERA_LAYOUT_CLIPPING_ENABLED defines whether Candera2D layout clipping (setting a clipping rectangle for every render node) is enabled or not.
#define CANDERA_LAYOUT_CLIPPING_ENABLED

/// CANDERA_3D_ENABLED defines whether Candera3D sources shall be included or not.
#define CANDERA_3D_ENABLED

/// CANDERA_3D_CANVAS_ENABLED defines whether Candera3D Canvas is enabled or not.
#define CANDERA_3D_CANVAS_ENABLED

/// CANDERA_RENDER_STATE_CACHING_ENABLED defines whether render device shall cache render states or not.
#define CANDERA_RENDER_STATE_CACHING_ENABLED

/// CANDERA_META_DESCRIPTION defines whether meta description used by SceneComposer shall be included or not.
/* #undef CANDERA_META_DESCRIPTION */

/// CANDERA_GLOBALIZATION_ENABLED defines whether globalization support is enabled or not.
#define CANDERA_GLOBALIZATION_ENABLED

#if defined(CANDERA_GLOBALIZATION_ENABLED)
    /// CANDERA_CUSTOM_LOCALIZER_ENABLED whether or not a custom Localizer must be used instead of the DefaultLocalizer.
/* #undef CANDERA_CUSTOM_LOCALIZER_ENABLED */
#endif

/// CANDERA_ASSET_DECOMPRESSION_ENABLED defines whether asset decompression is enabled or not.
/* #undef CANDERA_ASSET_DECOMPRESSION_ENABLED */
#if defined(CANDERA_ASSET_DECOMPRESSION_ENABLED)
    /// CANDERA_ASSET_DECOMPRESSION_CHUNK_SIZE defines the chunk buffer size for asset decompression. This value is only relevant for File Asset Repositories.
/* #undef CANDERA_ASSET_DECOMPRESSION_CHUNK_SIZE */
#endif
   
/// CANDERA_ASSET_CACHE_SIZE defines the buffer size for asset caching. A memory chunk of this size will be allocated for caching asset chunks for fast access.
#define CANDERA_ASSET_CACHE_SIZE 16384
    
/// CANDERA_ASSETLOADER_MEMORYPOOL_ENABLED defines whether asset loader objects are allocated from a dedicated memory pool or not.
/* #undef CANDERA_ASSETLOADER_MEMORYPOOL_ENABLED */

/// CANDERA_ASSETLOADER_WORKER_THREAD_ENABLED Uses an own worker thread for asynchronous asset loader calls. 
#define CANDERA_ASSETLOADER_WORKER_THREAD_ENABLED

/// CANDERA_TEXTENGINE_MEMORYPOOL_ENABLED defines whether text engine objects are allocated from a dedicated memory pool or not.
/* #undef CANDERA_TEXTENGINE_MEMORYPOOL_ENABLED */

/// CANDERA_MULTILINE_TEXT_ENABLED defines whether multiline texts are enabled or not.
#define CANDERA_MULTILINE_TEXT_ENABLED

/// CANDERA_TEXTENGINE_WORKER_THREAD_ENABLED Uses an own worker thread for asynchronous textrender calls. It uses the update routine (single threaded) when this flag is disabled.
#define CANDERA_TEXTENGINE_WORKER_THREAD_ENABLED

/// CANDERA_TEXTENGINE_NATIVE_LINEHEIGHT_ENABLED The native line height metrics of the font engine is used. If disabled then 120% of EM size is applied as line height which is compatible with Adobe.
#define CANDERA_TEXTENGINE_NATIVE_LINEHEIGHT_ENABLED

/// CANDERA_BIDIRECTIONAL_TEXT_ENABLED defines whether bidirectional text parsing is enabled or not.
#define CANDERA_BIDIRECTIONAL_TEXT_ENABLED

/// CANDERA_TEXT_SHAPER defines the name of the text shaper.
#define CANDERA_TEXT_SHAPER_HARFBUZZ

// CANDERA_TEXTSHAPER_HARFBUZZ_FORCE_ENABLED defines whether the additional shaper: HarfBuzz is available
/* #undef CANDERA_TEXTSHAPER_HARFBUZZ_FORCE_ENABLED */
// CANDERA_TEXTSHAPER_COMPLEXSCRIPT_FORCE_ENABLED defines whether the additional shaper: ComplexScript is available
/* #undef CANDERA_TEXTSHAPER_COMPLEXSCRIPT_FORCE_ENABLED */
// CANDERA_TEXTSHAPER_WORLDTYPE_FORCE_ENABLED defines whether the additional shaper: WorldType is available
/* #undef CANDERA_TEXTSHAPER_WORLDTYPE_FORCE_ENABLED */

/// CANDERA_COURIER_ENABLED defines whether Courier is included in the build or not.
#define CANDERA_COURIER_ENABLED

/// defines which font engine to use
#define CANDERA_FONTENGINE Freetype
#define CANDERA_FONTENGINE_FREETYPE

/// CANDERA_TEXTENGINE_HARFBUZZ_CLIG_FEATURE_ENABLED defines if Contextual Ligatures (clig) are enabled or not (support only in Harfbuzz for now)
#define CANDERA_TEXTENGINE_HARFBUZZ_CLIG_FEATURE_ENABLED

/// CANDERA_TEXTENGINE_HARFBUZZ_DLIG_FEATURE_ENABLED defines if Discretionary Ligatures (dlig) are enabled or not (support only in Harfbuzz for now)
/* #undef CANDERA_TEXTENGINE_HARFBUZZ_DLIG_FEATURE_ENABLED */

/// CANDERA_TEXTENGINE_HARFBUZZ_LIGA_FEATURE_ENABLED defines if Standard Ligatures (liga) are enabled or not (support only in Harfbuzz for now)
#define CANDERA_TEXTENGINE_HARFBUZZ_LIGA_FEATURE_ENABLED

/// CANDERA_TEXTENGINE_HARFBUZZ_LOCL_FEATURE_ENABLED defines if Localized Forms (locl) are enabled or not (support only in Harfbuzz for now)
#define CANDERA_TEXTENGINE_HARFBUZZ_LOCL_FEATURE_ENABLED

/// CANDERA_VRAM_ALLOCATOR_CHECK_ENABLED defines whether additional VRAM allocator check patterns are enabled to be verified during runtime is enabled or not.
/* #undef CANDERA_VRAM_ALLOCATOR_CHECK_ENABLED */

/// CANDERA_VRAM_ALLOCATOR_STATISTICS_ENABLED defines whether additional VRAM allocator statistics like e.g. remaining space is enabled or not.
/* #undef CANDERA_VRAM_ALLOCATOR_STATISTICS_ENABLED */

/// Activate support for video memory allocation statistics. ATTENTION: Activated memory statistics may decrease performance!
/* #undef CANDERA_VIDEO_MEMORY_STATISTIC_ENABLED */

/// Activate interface for persisting shader program binaries. ATTENTION: Requires OpenGLES2 Extension or OpenGLES3 
#define CANDERA_SHADER_PROGRAM_PERSIST_INTERFACE_ENABLED


/// Candera Performance Recorder 

#define CGIDEVICE_TARGET_BUILD
#if !defined(CGIDEVICE_TARGET_BUILD)
    #define CANDERA_GPU_SIMULATION
#endif

/// CANDERA_MAX_TEXTURE_UNIT_COUNT defines the maximum number of texture units supported. Candera supports
/// up to 8 texture units although the render device may support more than this number.
#if !defined(CANDERA_MAX_TEXTURE_UNIT_COUNT)
    #define CANDERA_MAX_TEXTURE_UNIT_COUNT 8
#elif CANDERA_MAX_TEXTURE_UNIT_COUNT > 8
    #define CANDERA_MAX_TEXTURE_UNIT_COUNT 8
#endif

/// CANDERA_MAX_CONTEXT_COUNT defines how many GPU contexts are supported. Candera supports
/// up to 4 contexts although the render device may support more than this number.
#if !defined(CANDERA_MAX_CONTEXT_COUNT)
    #define CANDERA_MAX_CONTEXT_COUNT 4
#endif
#if !defined(CANDERA_MAX_CONTEXT_COUNT)
    // If not defined by cmake, fallback to 4.
    #define CANDERA_MAX_CONTEXT_COUNT 4
#endif

/// CANDERA_MAX_LIGHTS_COUNT defines the maximum number of lights that can be activated simultaneously. 
/// Candera supports up to 8 lights although the render device may support more than this number.
#if !defined(CANDERA_MAX_LIGHTS_COUNT)
    #define CANDERA_MAX_LIGHTS_COUNT 8
#elif CANDERA_MAX_LIGHTS_COUNT > 8
    #define CANDERA_MAX_LIGHTS_COUNT 8
#endif

#if !defined(CANDERA_PERFCOUNTER_RESOLUTION)
    /** defines resolution of Candera performance counters in micro seconds
        default is 20 micro seconds. 20 micro seconds resolution enable timings
        with UInt16 up to 1 second and almost 24 hours with UInt32.
        Increase resolution to extend monitoring times, decrease to increase
        accuracy of performance monitoring. */
    #define CANDERA_PERFCOUNTER_RESOLUTION 20
#endif

// Enable/disable 4 bit per pixel text glyph and surface cache.
/* #undef CANDERA_4BIT_GLYPH_CACHE_ENABLED */

/// CANDERA_SCRIPTING_ENABLED defines whether CanderaScripting sources shall be included or not.
#define CANDERA_SCRIPTING_ENABLED

/// CANDERA_SCRIPTING_ENABLED defines whether CanderaScripting sources shall be included or not.
#define CANDERA_TRANSITIONS_ENABLED

// Candera 2D over 3D shaders external shader builder files.

/* #undef CANDERA_EXTERNAL_SHADER_BUILDER_HEADER_INCLUDE */

// Candera builds with legacy behaviors
/* #undef CANDERA_LEGACY_BEHAVIORS_ENABLED */

// -----------------------------------------------------------------------------
// Build mode dependant defines
// -----------------------------------------------------------------------------
#if FEATSTD_BUILD_MODE == FEATSTD_BUILD_MODE_DEBUG
    /** CANDERA_DEBUG indicates that the build shall include Candera debugging facilities. */
    #define CANDERA_DEBUG    1
    #if defined(CANDERA_NODEBUG)
        #undef CANDERA_NODEBUG
    #endif
#elif FEATSTD_BUILD_MODE == FEATSTD_BUILD_MODE_RELEASE || FEATSTD_BUILD_MODE == FEATSTD_BUILD_MODE_MINSIZEREL || FEATSTD_BUILD_MODE == FEATSTD_BUILD_MODE_RELWITHDEBINFO
    /** CANDERA_NODEBUG indicates that the build shall not include Candera debugging facilities. */
    #define CANDERA_NODEBUG 1
    #if defined(CANDERA_DEBUG)
        #undef CANDERA_DEBUG
    #endif
#else
#   error "Build mode FEATSTD_BUILD_MODE is unknown or undefined."
#endif


/** Defines the full name (path + name) for the platform specific header file which defines native invalid values for EGL Display and EGL Window.*/
/* #undef NATIVE_EGL_INVALID_VALUES_HEADER */
#if defined(NATIVE_EGL_INVALID_VALUES_HEADER)
#define NATIVE_EGL_INVALID_VALUES_HEADER_INCLUDE <NATIVE_EGL_INVALID_VALUES_HEADER>
#endif


// -----------------------------------------------------------------------------
// Feature defines based on Monitor CMake features
// -----------------------------------------------------------------------------

/** Defines whether Custom Experiments can be used or not (Only available when using monitor/analyzer) */
/* #undef MONITOR_CANDERA_CUSTOM_EXPERIMENTS */

/// Candera Performance Recorder 
/* #undef MONITOR_CANDERA_PERFORMANCE_RECORDER_ENABLED */


/// Enables all OpenGL Recorder (e.g. Timing Recorder of OpenGL). 
/* #undef MONITOR_RECORDING_OPENGL_ENABLED */

/// Enables all 2D driver calls.
/* #undef MONITOR_RECORDING_2D_CALLS_ENABLED */

// enables frame debugger features
/* #undef MONITOR_FRAME_DEBUGGER_ENABLED */

// enables low-level frame debugger
/* #undef MONITOR_FRAME_DEBUGGER_OPENGL_CAPTURE_ENABLED */

// enables OpenGL render state cache validation
/* #undef MONITOR_FRAME_DEBUGGER_OPENGL_STATE_CACHE_CHECKS_ENABLED */

// frame interval for single-step mode
/* #undef MONITOR_SINGLE_STEP_INTERVAL */
/// @}

#include <CanderaDeprecated.h>

// -----------------------------------------------------------------------------
// SCHost.lib build settings
// -----------------------------------------------------------------------------
/* #undef COLLECT_SOURCES_FOR_SCHOST */

#ifdef COLLECT_SOURCES_FOR_SCHOST
    #define CANDERA_TEXT_SHAPER_COMPLEXSCRIPTLIB
        
    #define CANDERA_ASSET_DECOMPRESSION_ENABLED
/* #undef CANDERA_ASSET_DECOMPRESSION_CHUNK_SIZE */
       
    #undef CANDERA_ASSETLOADER_MEMORYPOOL_ENABLED
    #undef CANDERA_TEXTENGINE_MEMORYPOOL_ENABLED
    
    #undef CANDERA_ASSETLOADER_WORKER_THREAD_ENABLED
#endif  // COLLECT_SOURCES_FOR_SCHOST

#endif  // CANDERA_CONFIG_H

// Customer specific settings

#define CANDERA_IGNORE_LAYOUTER_DEPRECATED_3_4_2_ENABLED
