//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "VLQEncoding.h"
#include <FeatStd/Util/FeatLimits.h>

namespace FeatStd { namespace Internal {
    static const UInt8 cValueBitmask = 0x7F;
    static const UInt8 cNewByteBitmask = static_cast<UInt8>(~cValueBitmask);

    // ------------------------------------------------------------------------
    template<typename T, typename UT>
    static UInt8 Read7BitEncodedInt(T& result, UInt8 const * buf, SizeType const bufSize)
    {
        UInt8 byteCnt = 0;
        UInt8 val = 0;
        result = 0;
        UT bitOpResult = 0;
        do
        {
            FEATSTD_DEBUG_ASSERT(byteCnt < bufSize);
            if (byteCnt == bufSize){
                break;
            }
            val = buf[byteCnt];
            bitOpResult |= (static_cast<UT>(val & cValueBitmask) << (byteCnt++ * 7));
        } while ((val & cNewByteBitmask) != 0);
        result = static_cast<T>(bitOpResult);
        return byteCnt;
    }

    // ------------------------------------------------------------------------
    template<typename T, typename UT>
    static UInt8 Write7BitEncodedInt(T value, UInt8 * buf, SizeType const maxLength)
    {
        FEATSTD_DEBUG_ASSERT(maxLength > 0);
        UInt8 writtenBytes = 0;
        bool isFirst = value < 0;
        UT bitOpValue = static_cast<UT>(value);
        UInt8 tmpResult = 0;
        if (buf != 0)
        {
            do
            {
                tmpResult = static_cast<UInt8>(bitOpValue & (cValueBitmask));
                if (!isFirst)
                {
                    bitOpValue >>= 7;
                }
                else
                {
                    bitOpValue >>= 1;
                    bitOpValue &= static_cast<UT>(NativeTypeLimit<T>::Max());
                    bitOpValue >>= 6;
                    isFirst = false;
                }
                if (bitOpValue != 0)
                {
                    if (writtenBytes < maxLength - 1){
                        tmpResult |= cNewByteBitmask;
                    }
                    else
                    {
                        // This code should never be reached.
                        // Otherwise provided  buffer is too small
                        FEATSTD_DEBUG_ASSERT(writtenBytes >= maxLength - 1);
                    }
                }

                buf[writtenBytes++] = tmpResult;
            } while ((tmpResult & cNewByteBitmask) != 0);
        }
        return writtenBytes;
    }

    // ------------------------------------------------------------------------
    UInt8 VLQEncoding::Write7BitEncodedInt(Int32 value, UInt8 * buf, SizeType const maxLength)
    {
        return FeatStd::Internal::Write7BitEncodedInt<Int32, UInt32>(value, buf, maxLength);
    }

    // ------------------------------------------------------------------------
    UInt8 VLQEncoding::Write7BitEncodedInt64(Int64 value, UInt8 * buf, SizeType const maxLength)
    {
        return FeatStd::Internal::Write7BitEncodedInt<Int64, UInt64>(value, buf, maxLength);
    }

    // ------------------------------------------------------------------------
    UInt8 VLQEncoding::Read7BitEncodedInt(Int32& result, UInt8 const * buf, SizeType const bufSize)
    {
        return FeatStd::Internal::Read7BitEncodedInt<Int32, UInt32>(result, buf, bufSize);
    }

    // ------------------------------------------------------------------------
    UInt8 VLQEncoding::Read7BitEncodedInt64(Int64& result, UInt8 const * buf, SizeType const bufSize)
    {
        return FeatStd::Internal::Read7BitEncodedInt<Int64, UInt64>(result, buf, bufSize);
    }
}}
