//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(FEATSTD_STRING_STRINGDATA_H)
#define FEATSTD_STRING_STRINGDATA_H

#include <FeatStd/Util/StringDataBase.h>
#include <FeatStd/Util/PointerUtil.h>

FEATSTD_UNIT_TEST_TESTCASE_DECLARATION(String, String)
FEATSTD_UNIT_TEST_TESTCASE_DECLARATION(String, ConstructorTest)
FEATSTD_UNIT_TEST_TESTCASE_DECLARATION(StringData, StringData)
FEATSTD_UNIT_TEST_TESTCASE_DECLARATION(StringData, StringDataBase)


namespace FeatStd {
    class Variant;
    namespace Internal {
/// @addtogroup FEATSTD_UTILS
/// @{
    /**
     *  StringData for static (not localized) strings.
     */
    class StringData : public StringDataBase {
        public:
            StringData();
            virtual ~StringData();

            virtual const TChar* GetCString() const;
            virtual bool HasChanged() const { 
                return false; 
            }

            virtual bool IsEmpty() const;

              /**
            * Create method which allocates contiguous memory for object and it's memebers
            * @param  charCount       Number of characters in the string.
            * @param  text            Text within string.
            */
         static StringData* Create(SizeType charCount, const TChar *text);
         virtual void Destroy();

        protected:
            virtual bool ShouldDecRefCount() const;

        private:
            static StringData* GetEmptyStringData();
            static TChar* GetEmptyText();

            static StringData* TextToStringData(TChar *str) { 
                StringData* result=0;
                if(str!=0){
                    result=PointerToPointer<StringData *>(str) - 1; 
                }
                return result;
            }

            friend class FeatStd::Variant;
            friend class FeatStd::String;
            friend struct PreDefinedStringBuffer;
            FEATSTD_UNIT_TEST_TESTCASE_FRIEND(String, String);
            FEATSTD_UNIT_TEST_TESTCASE_FRIEND(String, ConstructorTest);
            FEATSTD_UNIT_TEST_TESTCASE_FRIEND(StringData, StringData);
            FEATSTD_UNIT_TEST_TESTCASE_FRIEND(StringData, StringDataBase);
    };
/// @}
}}
#endif  // FEATSTD_STRING_STRINGDATA_H
