//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include <FeatStd/LifeTimeManager.h>
#include "StaticObject.h"
#include <FeatStd/Diagnostics/Log.h>
#include <FeatStd/Platform/CriticalSectionLocker.h>

namespace FeatStd { namespace Internal { namespace StaticObjectPrivate {

    // ---------------------------------------------------------------------
    void DtorListNode::Enlist()
    {
        StaticObjectManager::Enlist(this);
    }

}}}

namespace FeatStd { 

    //FEATSTD_LOG_SET_REALM(FeatStd::Diagnostics::LogRealm::FeatStdMemoryManagement);

    using namespace FeatStd::Internal;
    StaticObjectPrivate::DtorListNode *StaticObjectManager::mListHead = 0;

    // ---------------------------------------------------------------------
    static FeatStd::Internal::CriticalSection& GetCs() 
    {
        static FeatStd::Internal::CriticalSection cs;
        return cs;
    }

    // ---------------------------------------------------------------------
    void StaticObjectManager::Enlist(StaticObjectPrivate::DtorListNode *objectNode) 
    {
        FEATSTD_DEBUG_ASSERT(objectNode != 0 && objectNode->mNext == objectNode);

        FeatStd::CriticalSectionLocker lock(&GetCs());

        objectNode->mNext = mListHead;
        StaticObjectManager::mListHead = objectNode;

        if (objectNode->mNext == 0) {
            // ensure that LifeTimeManager starts the life time of 
            // StaticObjectManager
            FEATSTD_LINT_NEXT_EXPRESSION(1061, "false positive - StartLifeTime is accessible through using declaration")
            Internal::LifeTimeManager::StartLifeTime();
        }
    }

    // ---------------------------------------------------------------------
    void StaticObjectManager::DestructStaticObjects()
    {
        // no locking required - executed from LifeTimeManager in single threaded
        // environment

        while (mListHead != 0) {
            StaticObjectPrivate::DtorListNode *next = mListHead->mNext;
            mListHead->mDestruct(mListHead + 1);
            mListHead = next;
        }
    }

}
