//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#ifndef FeatStd_Util_DefaultValidationHelper_h__
#define FeatStd_Util_DefaultValidationHelper_h__

#include <FeatStd/Util/ValidationHelperBase.h>
#include <FeatStd/MemoryManagement/SharedPointer.h>
namespace FeatStd
{
    /// @addtogroup FEATSTD_UTILS
    /// @{
    /**
    *  @brief A standard validator which uses a counter.
    *         - Invalidating increases the counter
    *         - Validating decreases the counter
    *         - Resets validates the validator
    *         - The validator is valid when counter == 0
    */
    class DefaultValidationHelper : public ValidationHelperBase {
    public:
        DefaultValidationHelper();

        FEATSTD_SHARED_POINTER_CREATE_DECLARATION()
        {
            return SharedPointer(FEATSTD_NEW(DefaultValidationHelper)());
        }

    protected:

        virtual void SetInvalidImplementation() override;

        virtual void SetValidImplementation() override;

        virtual bool IsValidImplementation() const override;

        virtual void ResetImplementation() override;

        virtual void ConfirmValidHandledImplementation() override;

    private:
        UInt16 m_nodeCount;
    };
    /// @}
}
#endif // DefaultValidationHelper_h__
