//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(FeatStd_Utils_ConvenienceMacros_h)
#define FeatStd_Utils_ConvenienceMacros_h

#ifndef FeatStd_Config_h
    #error Please include <FeatStd/Config.h> before this file!
#endif

#include <FeatStd/Util/WarningMacros.h>

/// @addtogroup FEATSTD_UTILS
/// @{
/******************************************************************************
 *  Macros to avoid variable/parameter unused warnings
 ******************************************************************************/
#define FEATSTD_UNUSED(a)              (void) a
#define FEATSTD_UNUSED2(a, b)          FEATSTD_UNUSED(a); (void) b
#define FEATSTD_UNUSED3(a, b, c)       FEATSTD_UNUSED2(a, b); (void) c
#define FEATSTD_UNUSED4(a, b, c, d)    FEATSTD_UNUSED3(a, b, c); (void) d
#define FEATSTD_UNUSED5(a, b, c, d, e) FEATSTD_UNUSED4(a, b, c, d); (void) e

#if defined(FEATSTD_DEBUG)
    #define FEATSTD_DEBUG_UNUSED(a) FEATSTD_UNUSED(a)
    #define FEATSTD_RELEASE_UNUSED(a)
#else
    #define FEATSTD_DEBUG_UNUSED(a)
    #define FEATSTD_RELEASE_UNUSED(a) FEATSTD_UNUSED(a)
#endif


/** FEATSTD_TYPEDEF_BASE suppresses Lint warning 1516 when the declaration
    "typedef <TypeOfBaseClass> Base" is used in a derived class
    to access its base by a standard term, similar to "super" or "base" in
    other languages. Due to the nature of this declaration, it is statically
    used within the declaring class and may hide inherited "Base". 
*/
#define FEATSTD_TYPEDEF_BASE( CLASS ) \
    FEATSTD_LINT_SYMBOL(1516, *Base, "Typedef to Base is used in a derived class to access its base class by standard term.") \
    typedef CLASS  Base


/** use this to make a class uninstantiable
    to prevent instantiation, this macro will declare an empty default ctor
    for the given type.
    The macro must be placed into the private section of the class declaration.

    @param Type the type instantiation should be inhibited for.

    @code
    class Foo {
        public:
            ...
        private:
            FEATSTD_MAKE_CLASS_STATIC(Foo);
    };
    @endcode
 */
#define FEATSTD_MAKE_CLASS_STATIC(Type) \
    FEATSTD_LINT_NEXT_EXPRESSION(1704, "it is the exact intention of this macro to make the ctor private (disallow instances)") \
    Type()

/** use this to make a class uncopyable
    to prevent objects from being copied or assigned to, this macro will declare
    empty copy ctor and assignment operator for the given type. The macro must be
    placed into the private section of the class declaration.

    In addition an anonymous enum with the enumerator UncopyableClass set to true

    @param Type the type copying should be inhibited for.

    @code
    class Foo {
        public:
            Foo();
            ...
        private:
            FEATSTD_MAKE_CLASS_UNCOPYABLE(Foo);
    };
    @endcode
 */
#define FEATSTD_MAKE_CLASS_UNCOPYABLE(Type) \
    FEATSTD_LINT_NEXT_EXPRESSION(1704, "FEATSTD_MAKE_CLASS_UNCOPYABLE intention is to make the copy ctor private") \
    Type(const Type&); \
    Type& operator=(const Type&)

/// _FEATSTD_DEPRECATED must not be used directly!
/// See FeatStd/Macros for details!
FEATSTD_LINT_SYMBOL(665, _FEATSTD_DEPRECATED, "Second parameter has to be used unparenthesized in _FEATSTD_DEPRECATED")
#if defined(__GNUC__) || defined(__MINGW32__) || defined(__ghs__) || defined (__CC_ARM) || defined (__ICCARM__)
    #define _FEATSTD_DEPRECATED(msg, func) \
        func __attribute__ ((deprecated))
#elif defined(_MSC_VER)
    #define _FEATSTD_DEPRECATED(msg, func) \
        __declspec(deprecated("DEPRECATED! - " msg)) func
#else
    #pragma message("WARNING: Deprecated interface!")
    #define _FEATSTD_DEPRECATED(msg, func) func
#endif

// Usage example: _FEATSTD_DEPRECATED_FILE("Widgets are deprecated, please use Behaviors instead.", ImageSelectWidget2D_h);
#define _FEATSTD_DEPRECATED_FILE(msg, file_descriptor) \
    namespace file_descriptor { \
        struct header_file { \
            _FEATSTD_DEPRECATED(msg, inline static void used()); \
            inline static void use() { used(); } \
        }; \
        inline void header_file::used() { } \
    }

#if defined(__GNUC__) || defined(__MINGW32__) || defined(__ghs__) || defined (__CC_ARM) || defined (__ICCARM__)
#define _FEATSTD_DEPRECATED_CONST(msg, constant) \
    __attribute__ ((deprecated)) constant
#elif defined(_MSC_VER)
#define _FEATSTD_DEPRECATED_CONST(msg, constant) \
    __declspec(deprecated("DEPRECATED! - " msg)) constant
#else
#pragma message("WARNING: Deprecated constant!")
#define _FEATSTD_DEPRECATED(msg, constant) constant
#endif

#if defined(__GNUC__) || defined(__MINGW32__) || defined(__ghs__) || defined (__CC_ARM)
#define FEATSTD_WARNING(msg) \
    FEATSTD_PRAGMA(message(msg))
#elif defined(_MSC_VER)
#define _FEATSTD_LOCATION FEATSTD__FILE__ "(" FEATSTD_STRINGIZE(__LINE__) ") : Warning: "

#define FEATSTD_WARNING(msg) \
    FEATSTD_PRAGMA(message(_FEATSTD_LOCATION msg))
#else
#define FEATSTD_WARNING(msg)
#endif

/// Generates gTest class name out of fixture and test case name.
#define _FEATSTD_UNIT_TEST_CLASS_NAME(testCaseName, testName) \
    testCaseName##_##testName##_Test
/// @}

#if !defined(_MSC_VER) || (_MSC_VER < 1700)
#ifndef override
    #define override
#endif
#ifndef final
    #define final
#endif
#endif

/******************************************************************************
*  Macros to turn on/off the Code Coverage Tool
******************************************************************************/
#if defined(_BullseyeCoverage)
    #define FEATSTD_COVERAGE_EXCLUDE_BEGIN(reason) FEATSTD_PRAGMA(BullseyeCoverage off)
    #define FEATSTD_COVERAGE_EXCLUDE_END FEATSTD_PRAGMA(BullseyeCoverage on)
#else
    #define FEATSTD_COVERAGE_EXCLUDE_BEGIN(reason)
    #define FEATSTD_COVERAGE_EXCLUDE_END
#endif

/** The default case of the current switch statement cannot be reached */
#define COVERAGE_EXCLUDE_REASON_UNREACHABLE_DEFAULT_CASE

#endif


