//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "BitKit.h"

namespace FeatStd { namespace Internal {


UInt8 BitKit::CountBits(UInt32 source)
{
    // from Hacker's Delight, Page 68
    UInt32 n = (source >> 1U) & 0x77777777U;
    source -= n;
    n = (n >> 1U) & 0x77777777U;
    source -= n;
    n = (n >> 1U) & 0x77777777U;
    source -= n;
    source = (source + (source >> 4U)) & 0x0f0f0f0fU;
    source *= 0x01010101U;
    return UInt8(source >> 24U);
}

}}
