//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "Ticks.h"

namespace FeatStd { namespace Internal {
    Ticks::Ticks(TicksType::Enum ticksType)
    {
        switch (ticksType) {
            case TicksType::Now:
                mTicks = Base::GetSystemTicks();
                break;
            case TicksType::Infinite:
                mTicks = Base::Infinite();
                break;
            case TicksType::Zero:
            default:
                mTicks = 0;
        }
    }
}}
