//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(FeatStd_Platform_TickValue_h)
#define FeatStd_Platform_TickValue_h

#include <FeatStd/Base.h>

namespace FeatStd { namespace Internal {
/// @addtogroup FEATSTD_PLATFORM
/// @{
    /** Class TickValue is a helper class to store tick values into a Ticks object. */
    class TickValue {
    public:
        ///
        TickValue() : mTickValue(0) {}

        ///
        TickValue(UInt32 tickValue) : mTickValue(tickValue) {}

        ///
        TickValue(const TickValue & tickValue) : mTickValue(tickValue.mTickValue) {}

        ///
        UInt32 Get() const { return mTickValue; }

        ///
        TickValue & operator=(const TickValue & tickValue) { mTickValue = tickValue.mTickValue; return *this; }

        ///
        TickValue operator +(const TickValue & tickValue) const {
            TickValue sum;
            sum.mTickValue = mTickValue + tickValue.mTickValue;
            return sum;
        }

        ///
        TickValue & operator +=(const TickValue & tickValue) { mTickValue += tickValue.mTickValue; return *this; }

        ///
        TickValue operator -(const TickValue & tickValue) const {
            TickValue lDiff;
            lDiff.mTickValue = mTickValue - tickValue.mTickValue;
            return lDiff;
        }

        ///
        TickValue & operator -=(const TickValue & tickValue) { mTickValue -= tickValue.mTickValue; return *this; }

        ///
        bool operator ==(const TickValue & tickValue) const { return mTickValue == tickValue.mTickValue; }

        ///
        bool operator !=(const TickValue & tickValue) const { return mTickValue != tickValue.mTickValue; }

        ///
        bool operator >(const TickValue & tickValue) const { return mTickValue > tickValue.mTickValue; }

        ///
        bool operator <(const TickValue & tickValue) const { return mTickValue < tickValue.mTickValue; }

        ///
        bool operator >=(const TickValue & tickValue) const { return mTickValue >= tickValue.mTickValue; }

        ///
        bool operator <=(const TickValue & tickValue) const { return mTickValue <= tickValue.mTickValue; }

        /// Conversion
        operator UInt32() { return mTickValue; }

    private:
        UInt32 mTickValue;
    };
/// @}
}}
#endif
