//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(FeatStd_Platform_Posix_PosixTypes_h)
#define FeatStd_Platform_Posix_PosixTypes_h

#include <wchar.h>
#include <cstddef>
#include <FeatStd/Macros.h>

#include <stdint.h>
#include <limits.h>


namespace FeatStd { namespace Internal { namespace Posix {
    /// @addtogroup FEATSTD_PLATFORM_POSIX
    /// @{
    namespace PosixTypes {

        /** Char data type
            Char data stores a single 8 bit character. */
        typedef char Char;

        /** UCS2 data type. */
        typedef wchar_t Ucs2Char;

        /** Char data type used for strings passed to the TextRenderer (see TextRenderer::DrawText()).
            The typedef allows to specify different sizes (e. g. char or wchar_t), the encoding (ASCII,
            UTF-8, UTF-16, ...) is defined by the the value of TCharIsUtfEncoded. */ 
        typedef char TChar;

        enum { 
            TCharEncodingScheme = CharacterEncodingScheme::UTF8,
            TCharIsUtfEncoded = true
        };

        /** Int data type.
            Int data stores signed integral data with architecture dependent bit size.
            Int shall at least store 16 bit data. */
        typedef signed int Int;

        /** UInt data type.
            UInt data stores unsigned integral data with architecture dependent bit size.
            UInt shall at least store 16 bit data.
            The return value of the sizeof() operator (size_t) is defined as UInt. */
        typedef unsigned int UInt;

        /** Int8 data type.
           Int8 data stores signed 8 bit integral data. */
        typedef signed char Int8;

        /** UInt8 data type.
            UInt8 data stores unsigned 8 bit integral data. */
        typedef unsigned char UInt8;

        /** Int16 data type.
            Int16 data stores signed 16 bit integral data. */
        typedef signed short Int16;

        /** UInt16 data type.
            UInt16 data stores unsigned 16 bit integral data. */
        typedef unsigned short UInt16;

        /** Int32 data type.
            Int32 data stores signed 32 bit integral data. */
        typedef signed int Int32;

        /** UInt32 data type.
            UInt32 data stores signed 32 bit integral data. */
        typedef unsigned int UInt32;

        /** Int64 data type.
            Int64 data stores signed 64 bit integral data. */
        typedef signed long long Int64;

        /** Int64 data type.
            Int64 data stores unsigned 64 bit integral data. */
        typedef unsigned long long UInt64;

        /** Float data type.
            Float stores floating point data with 32 bits. */
        typedef float Float;

        /** Double data type.
            Double stores floating point data with 64 bits. */
        typedef double Double;

        /** Type for C/C++ bit field declarations */
        typedef unsigned BitField;

        /** std::size_t equivalent */
        typedef std::size_t SizeType;

        /** std::ptrdiff_t equivalent*/
        typedef std::ptrdiff_t OffsetType;
        
        /** Handle data type.
        Handle stores address data with 32 bits. */
        //typedef SizeType Handle;
    }    
    /// @}
    
    /** Max/min limits for posix types */
    namespace PosixLimits {
        static const PosixTypes::OffsetType OFFSETTYPE_MAX = 
#if defined (PTRDIFF_MAX)
            PTRDIFF_MAX;
#else
            LONG_MAX;
#endif

        static const PosixTypes::OffsetType OFFSETTYPE_MIN = 
#if defined (PTRDIFF_MIN)
            PTRDIFF_MIN;
#else
            LONG_MIN;
#endif

        static const PosixTypes::SizeType SIZETYPE_MAX = 
#if defined (SIZE_MAX)
            SIZE_MAX;
#else
            LONG_MAX;
#endif
    }    
}}}

namespace FeatStd { namespace Internal { namespace Impl {
    namespace Types = FeatStd::Internal::Posix::PosixTypes;
    namespace Limits = FeatStd::Internal::Posix::PosixLimits;
}}}

#endif
