//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include <FeatStd/Platform/Ticks.h>
//#include <FeatStd/Diagnostics/Log.h>

FEATSTD_LINT_FILE(829, errno.h, "platform dependent file")
//lint -efile(829, errno.h)  platform dependent file
FEATSTD_LINT_FILE(829, time.h, "platform dependent file")

#include <errno.h>
#include <time.h>

//FEATSTD_LOG_SET_REALM(FeatStd::Diagnostics::LogRealm::Platform);

#define LOG_SYSCALL_ERROR(syscall)   \
    /* FEATSTD_LOG_ERROR("Ticks: ::%s() failed (Error %d)", syscall, errno); */

namespace FeatStd { namespace Internal { namespace Posix {
    
    FEATSTD_LINT_CURRENT_SCOPE(1960, "Violates MISRA C++ 2008 Required Rule 5-18-1: false positive, comma operator is not used")
    FEATSTD_LINT_CURRENT_SCOPE(1013, "false positive, tv_sec and tv_nsec are members of timespec")
    // ------------------------------------------------------------------------
    TickValue PosixTicks::GetSystemTicks()
    {
        FEATSTD_LINT_SYMBOL(550, timeCurrent, "[MISRA C++ Rule 0-1-4] timeCurrent is not accessed is a false positive")
        
        UInt32 timeMs = 0;
        struct timespec timeCurrent;

        static_cast<void>(::clock_gettime(CLOCK_MONOTONIC, &timeCurrent));
        timeMs  = timeCurrent.tv_sec * 1000U;
        timeMs += timeCurrent.tv_nsec / 1000000U;
        
        return TickValue(timeMs);
    }

    // ------------------------------------------------------------------------
    TickValue PosixTicks::Infinite()
    {
        UInt32 lInfinite = UInt32(-1);
        return TickValue(lInfinite);
    }

    // ------------------------------------------------------------------------
    TickValue PosixTicks::Time2Ticks(UInt32 theTime)
    {
        return TickValue(theTime);
    }

    // ------------------------------------------------------------------------
    UInt32 PosixTicks::Ticks2Time(TickValue ticks)
    {
        return ticks;
    }
}}}
