//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(FeatStd_Platform_Posix_PosixSerialPort_h)
#define FeatStd_Platform_Posix_PosixSerialPort_h

#include <FeatStd/Platform/Base.h>
#include <termios.h> /* POSIX terminal control definitions */

typedef void *HANDLE;


namespace FeatStd {
    namespace Internal {
        namespace Posix {
            /// @addtogroup FEATSTD_PLATFORM_Posix
            /// @{
            // /** Posix SerialPort functionality supporting implementation of FeatStd::Internal::SerialPort. */
            class PosixSerialPort {
            public:
                typedef FeatStd::Internal::SerialSettings Settings;
                PosixSerialPort();

                bool DataAvailable(bool& available);
                Int32 Read(UInt8*buffer, UInt32 length);
                Int32 Write(const UInt8* buffer, UInt32 length);
                bool Configure(Settings const * configData);
                bool GetConfig(Settings& config) const{
                    config = mSettings;
                    return true;
                }
                bool Close();
                bool Connect(ConnectionHandshake handshake = 0);
                bool Connected();
                Settings const * GetConfiguration() const{ return &mSettings; }

            private:
                Int32 hPort;
                Settings mSettings;
                bool SetBaudrate(struct termios& options);
                bool SetParity(struct termios& options);
                bool DataAvailable(bool& available, UInt timeoutUSec) const;
                bool mConnected;
                bool mConnecting;
            };
            /// @}
        }
    }
}

namespace FeatStd {
    namespace Internal {
        namespace Impl {
            typedef FeatStd::Internal::Posix::PosixSerialPort SerialPort;
        }
    }
}

#endif
