//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(FeatStd_Platform_Posix_PosixSemaphore_h)
#define FeatStd_Platform_Posix_PosixSemaphore_h

#include <FeatStd/Platform/Base.h>
#include <FeatStd/Platform/Ticks.h>

#include <semaphore.h>

namespace FeatStd { namespace Internal { namespace Posix {
    /// @addtogroup FEATSTD_PLATFORM_POSIX
    /// @{
    /** Posix semaphore implementation */
    class PosixSemaphore {
    public:
        ///
        PosixSemaphore();

        ///
        virtual ~PosixSemaphore();

        ///
        bool Create(Int initVal = 0);

        ///
        bool Obtain(const Ticks & timeout);

        ///
        bool Obtain();

        ///
        bool Release();

        ///
        bool Destroy();

    private:
        ::sem_t mSem;

        FEATSTD_MAKE_CLASS_UNCOPYABLE(PosixSemaphore);
    };
    /// @}
}}}

namespace FeatStd { namespace Internal { namespace Impl {
    typedef FeatStd::Internal::Posix::PosixSemaphore Semaphore;
}}}

#endif
