//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(FeatStd_Platform_Posix_PerfCounter_h)
#define FeatStd_Platform_Posix_PerfCounter_h

#include <FeatStd/Platform/Base.h>

namespace FeatStd { namespace Internal { namespace Posix {

    struct PosixPerfCounter {
        static UInt32 Now();

        static UInt32 Elapsed(UInt32 counter) {
            return Now() - counter;
        }

        static UInt32 Duration(UInt32 start, UInt32 end) {
            return static_cast<UInt32>(end - start);
        }

        static UInt32 ShortDuration(UInt16 start, UInt16 end);
    };

}}}   // namespace Platform

namespace FeatStd { namespace Internal { namespace Impl {
    typedef FeatStd::Internal::Posix::PosixPerfCounter PerfCounter;
}}}

#endif
