//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include <FeatStd/Platform/PerfCounter.h>
#include <FeatStd/Util/NumericUtil.h>

FEATSTD_LINT_FILE(829, time.h, "platform dependent file")
#include <time.h>

namespace FeatStd { namespace Internal { namespace Posix {
    
    FEATSTD_LINT_CURRENT_SCOPE(1960, "Violates MISRA C++ 2008 Required Rule 5-18-1: false positive, comma operator is not used")
    FEATSTD_LINT_CURRENT_SCOPE(1013, "false positive, tv_sec and tv_nsec are members of timespec")
    // ----------------------------------------------------------------------------
    inline UInt32 TimeSpecToUInt32(const struct timespec &ts)
    {
        UInt32 calcTime = static_cast<UInt32>(ts.tv_sec * (1000000U / FEATSTD_PERFCOUNTER_RESOLUTION));
        calcTime += static_cast<UInt32>(ts.tv_nsec / (1000U * FEATSTD_PERFCOUNTER_RESOLUTION));
        return calcTime;
    }

    // ----------------------------------------------------------------------------
    static UInt32 GetTimerVal() 
    {
        static bool init = false;
        static UInt32 startTime;

        struct timespec ts;
        if (!init) {
            static_cast<void>(::clock_gettime(CLOCK_MONOTONIC, &ts));
            startTime = TimeSpecToUInt32(ts);
            init = true;
        }

        static_cast<void>(::clock_gettime(CLOCK_MONOTONIC, &ts));
        return TimeSpecToUInt32(ts) - startTime;
    }

    // ----------------------------------------------------------------------------
    UInt32 PosixPerfCounter::Now()
    {
        return GetTimerVal();
    }

    // ----------------------------------------------------------------------------
    UInt32 PosixPerfCounter::ShortDuration(UInt16 start, UInt16 end)
    {
        UInt32 duration;
        if (start <= end) {
            duration = static_cast<UInt32>(end) - start;
        }
        else {
            duration = (0xffff - static_cast<UInt32>(start)) + static_cast<UInt32>(end);
        }
        return duration;
    }
} } }
