//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(FeatStd_Macros_PlatformInclude_h)
#define FeatStd_Macros_PlatformInclude_h

#include <FeatStd/Config.h>

#include <FeatStd/Util/MacroKit.h>

/// @addtogroup FEATSTD_PLATFORM
/// @{
/** Macro to include platform specific header files.
    Usage:
    @code
        #include FEATSTD_PLATFORM_INCLUDE(AtomicOp)
    @endcode */
#define FEATSTD_PLATFORM_INCLUDE(file) <FeatStd/Platform/FEATSTD_OS/FEATSTD_CONCAT2(FEATSTD_OS, file).h>

/** includes a toolchain specific header file 
    Usage:
    @code
        #include FEATSTD_TOOLCHAIN_INCLUDE(AtomicOp)
    @endcode */
#define FEATSTD_TOOLCHAIN_INCLUDE(file) <FeatStd/Platform/FEATSTD_TOOLCHAIN_FAMILY/FEATSTD_CONCAT2(FEATSTD_TOOLCHAIN_FAMILY, file).h>
/// @}
#endif
