//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "GenericAtomicOp.h"
#include <FeatStd/Platform/CriticalSectionLocker.h>

namespace FeatStd { namespace Internal { namespace Generic {

    // ------------------------------------------------------------------------
    static CriticalSection* GetCS()
    {
        static CriticalSection cs;
        return &cs;
    }
    static CriticalSection* g_GenericAtomicOpCriticalSection = GetCS();

    // ------------------------------------------------------------------------
    GenericAtomicOp::Type GenericAtomicOp::AddAndFetch(Type &atomic, Type value)
    {
        CriticalSectionLocker lock(GetCS());
        atomic += value;
        return atomic;
    }
   
    // ------------------------------------------------------------------------
    GenericAtomicOp::Type GenericAtomicOp::SubAndFetch(Type &atomic, Type value)
    {
        CriticalSectionLocker lock(GetCS());
        atomic -= value;
        return atomic;
    }

    // ------------------------------------------------------------------------
    GenericAtomicOp::Type GenericAtomicOp::FetchAndAdd(Type &atomic, Type value)
    {
        CriticalSectionLocker lock(GetCS());
        Type tmp = atomic;
        atomic += value;
        return tmp;
    }
   
    // ------------------------------------------------------------------------
    GenericAtomicOp::Type GenericAtomicOp::FetchAndSub(Type &atomic, Type value)
    {
        CriticalSectionLocker lock(GetCS());
        Type tmp = atomic;
        atomic -= value;
        return tmp;
    }

    // ------------------------------------------------------------------------
    GenericAtomicOp::Type GenericAtomicOp::Set(Type& value, Type new_value)
    {
        CriticalSectionLocker lock(GetCS());
        Type previous_value = value;
        value = new_value;
        return previous_value;
    }

    // ------------------------------------------------------------------------
    bool GenericAtomicOp::TestAndSet(Type& value, Type expected_value, Type new_value)
    {
        CriticalSectionLocker lock(GetCS());
        bool match = (value == expected_value);
        if (match) {
            value = new_value;
        }
        return match;
    }

}}}
