//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(FeatStd_Platform_FractionalNumberMath_h)
#define FeatStd_Platform_FractionalNumberMath_h

#include <FeatStd/Base.h>

// Switch between floating point and fixed point arithmetic.

#ifndef FEATSTD_FIXED_POINT_ARITHMETIC

// Enable floating point.
#include FEATSTD_PLATFORM_INCLUDE(Math)

#else

// Enable fixed point.
#include "FixedPoint/FixedPointMath.h"

#endif

namespace FractionalNumber {
/// @addtogroup FEATSTD_PLATFORM
/// @{
#ifndef FEATSTD_FIXED_POINT_ARITHMETIC

    // Enable floating point.
    using FeatStd::Internal::Impl::Math;

#else

    using namespace FeatStd;

    // Enable fixed point.
    /**
    * @brief Abstraction layer for maths methods.
    * Extends FixedPointPlatform::Math and renames Fixed point names to Float names,
    * as requested by MathPlatform.
    */
    struct Math : public FeatStd::Internal::FixedPointMath::Math<FEATSTD_FIXED_POINT_FRACTIONAL_BITS>
    {
        /**
        * Compares two FeatStd::Float values.
        * @param a         The first value.
        * @param b         The second value.
        * @param relativeEpsilon, absoluteEpsilon   The accepted inaccuracy on comparison.
        *                                           If 99.999% accuracy is needed then pass a epsilon value of 0.00001.
        * @return          true if the given FeatStd::Float values are equal in respect to the given epsilon, otherwise false.
        */
        static inline bool FloatAlmostEqual(Float a, Float b, Float relativeEpsilon = EpsilonFloat(), Float absoluteEpsilon = EpsilonFloat3D()) { return FixedPointAlmostEqual(a, b, relativeEpsilon, absoluteEpsilon); }

        /** Returns the largest floating point number
            @return largest floating point number */
        static inline Float MaxFloat() { return MaxFixedPoint(); }

        /** Returns the smallest positive floating point number
            @return smallest floating point number */
        static inline Float MinFloat() { return MinFixedPoint(); }

        /** Returns the smallest positive number such that 1.0+number !=1.0
            @return Smallest positive number such that 1.0+number !=1.0 */
        static inline Float EpsilonFloat() { return EpsilonFixedPoint(); }

        /** Returns the smallest positive number acceptable as a relative error in math operations
            @return Smallest positive number acceptable as a relative error in math operations */
        static inline Float EpsilonFloat3D() { return EpsilonFixedPoint3D(); }
    };
#endif
/// @}
}
#endif
