//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(FeatStd_MemoryManagement_Allocator_h)
    #define FeatStd_MemoryManagement_Allocator_h

#if defined(FEATSTD_ENABLE_MEMORYPOOL_ALLOCATIONS)
    #include <FeatStd/MemoryPool/MemoryPool.h>
#endif

/// @addtogroup FEATSTD_MEMORYMANAGEMENT
/// @{
namespace FeatStd {
    namespace MemoryManagement {

#if defined(FEATSTD_ENABLE_MEMORYPOOL_ALLOCATIONS)

        /**
         *  \brief  Allocator class to be used for container template classes (e.g. Vector).
         *  
         *  Static methods Alloc() and Free() have to be implemented to define the memory pool for allocation.
         *  
         *  @tparam MemRealm    The realm (name of the memory pool).
         *  @tparam memAttrib   The attributes for the allocation (see MemAttrib::Enum).
         */
        template<typename MemRealm, MemAttrib::Enum memAttrib>
        class Allocator {
            public:
                static void* Alloc(FEATSTD_MEMORYPOOL_DECL_CONTEXT(UInt32 nBytes, location))
                {
                    return MemRealm::Alloc(FEATSTD_MEMORYPOOL_PASS_CONTEXT(nBytes, location), memAttrib);
                }

                static void Free(void* ptr)
                {
                    MemRealm::Free(ptr);
                }
        };

        /**
         *  The default allocator for container classes like Vector is using the FeatStd::DefaultMemoryPool with transient allocations.
         */
        typedef Allocator<DefaultMemoryPool, MemAttrib::Transient> DefaultAllocator;

#else    // !defined(FEATSTD_ENABLE_MEMORYPOOL_ALLOCATIONS)

        class DefaultAllocator {
            public:
                static void* Alloc(SizeType nBytes, const Char* file, Int32 line)
                {
                    return MemoryManagement::Internal::PlainAlloc(nBytes, file, line);
                }

                static void Free(void* ptr)
                {
                    FEATSTD_FREE(ptr);
                }

        };

#endif
    }   // namespace MemoryManagement
}   // namespace FeatStd

/// @}
#endif  // FeatStd_MemoryManagement_Allocator_h
