//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(FEATSTD_EVENT_H)
#define FEATSTD_EVENT_H

#include <FeatStd/Util/Rtti.h>

namespace FeatStd {
/// @addtogroup FEATSTD_EVENT
/// @{

    /**
    * @brief Event serves as a base class for user derived events.
    */
    class Event {
    public:
        FEATSTD_RTTI_DECLARATION();

        /**
         *  Destructor
         */
        virtual ~Event() {}

    protected:
        FEATSTD_MAKE_CLASS_STATIC(Event);

    private:
        FEATSTD_MAKE_CLASS_UNCOPYABLE(Event);
    };
/// @}
}

#endif
