//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(FeatStd_Diagnostics_Tracer_h)
#define FeatStd_Diagnostics_Tracer_h

#include <FeatStd/Base.h>

#ifdef FEATSTD_LOG_ENABLED
#include <FeatStd/Diagnostics/LogEvent.h>
#endif
#include <FeatStd/Diagnostics/LocationInfo.h>


namespace FeatStd { namespace Diagnostics {
/// @addtogroup FEATSTD_DIAGNOSTICS
/// @{
/**
 * Central class for almost all trace activities.
 * Most tracing operations, except general configuration (/link TraceControl /endlink),
 * are done through this class. <br>
 * Supports en-/disabling of Trace output.
 */
class Tracer
{
public:
    static bool IsEnabled() { return mEnabled; }
    static void SetEnabled(bool state);

#ifdef FEATSTD_LOG_ENABLED
    /** Forwards a log logEvent to Trace channel. */
    static void Mirror_LogEvent(const FeatStd::Diagnostics::LogEvent& logEvent);
#endif

private:
    static bool mEnabled;
};
/// @}
}}
#endif
