//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(FeatStd_Diagnostics_Measurable_h)
#define FeatStd_Diagnostics_Measurable_h

#include <FeatStd/Base.h>

namespace FeatStd { namespace Diagnostics {
/// @addtogroup FEATSTD_DIAGNOSTICS
/// @{
/**
 * @brief class Measurable is an interface that allows Diagnostic components
 *        like e.g. VideoMemoryStatistic to retrieve the size
 *        of an measurable object that implements this interface.
 */
class Measurable
{
public:
    Measurable() { }

    virtual ~Measurable() { }

    virtual UInt GetSize() const = 0;
};
/// @}
}}
#endif
