//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(FeatStd_Diagnostics_LogRealm_h)
#define FeatStd_Diagnostics_LogRealm_h

#if !defined(FEATSTD_IN_DIAGNOSTICS_LOG)
#error "please do not include this file directly, include FeatStd/Diagnostics/Log.h instead"
#endif

#include <FeatStd/Base.h>
#ifndef FEATSTD_LOG_ENABLED
    #error Feature FEATSTD_LOG_ENABLED is not enabled. Do not include any FeatStd logging releated header files!
#endif
#include <FeatStd/Diagnostics/Debug.h>

/// @addtogroup FEATSTD_DIAGNOSTICS
/// @{
#define FEATSTD_LOG_DECLARE_REALM(LogRealm) \
    struct LogRealm \
    { \
        static const FeatStd::Char* Name() { \
            return FEATSTD_STRINGIZE(LogRealm); \
        } \
    private: \
        FEATSTD_MAKE_CLASS_STATIC(LogRealm); \
    }

#ifdef _MSC_VER
#define FEATSTD_LOG_DECLARE_REALM_DEPRECATED(LogRealm) \
    struct __declspec(deprecated) LogRealm \
    { \
        static const FeatStd::Char* Name() { return #LogRealm; } \
    private: \
        FEATSTD_MAKE_CLASS_STATIC(LogRealm); \
    }
#else
#define FEATSTD_LOG_DECLARE_REALM_DEPRECATED(LogRealm) FEATSTD_LOG_DECLARE_REALM(LogRealm)
#endif

#define FEATSTD_LOG_DEFINE_REALM(LogRealm) \
    FEATSTD_LINT_NEXT_EXPRESSION(534, Called for instantiation only) \
    static_cast<void>(FeatStd::Diagnostics::LoggerTyped<LogRealm>::GetInstance())

namespace FeatStd { namespace Diagnostics { namespace LogRealm {
//! [FEATSTD_LogRealm_Declare]
FEATSTD_LOG_DECLARE_REALM(FeatStdSystem);
FEATSTD_LOG_DECLARE_REALM(FeatStdPlatform);
FEATSTD_LOG_DECLARE_REALM(FeatStdMemoryManagement);
FEATSTD_LOG_DECLARE_REALM(FeatStdMonitor);
FEATSTD_LOG_DECLARE_REALM(FeatStdAsync);
//! [FEATSTD_LogRealm_Declare]

//! [FEATSTD_LogRealm_User]
FEATSTD_LOG_DECLARE_REALM(User);
//! [FEATSTD_LogRealm_User]

void LoggerIterationInitialization();
}}}
/// @}
#endif
