//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "LogEvent.h"

namespace FeatStd { namespace Diagnostics {
LogEvent::LogEvent(const Char* logRealmName, LogLevel::Enum logLevel,
                   UInt32 timeStamp, const LocationInfo& location,
                   UInt32 threadId, const Char* message)
  : mLogRealmName(logRealmName),
    mLogLevel(logLevel),
    mTimeStamp(timeStamp),
    mLocation(location),
    mThreadId(threadId),
    mMessage(message)
{
    FEATSTD_DEBUG_ASSERT(mLogRealmName != 0);
    FEATSTD_DEBUG_ASSERT(mLogLevel != LogLevel::Off);
    FEATSTD_DEBUG_ASSERT(mMessage != 0);
}

LogEvent::~LogEvent()
{
}
}}
