//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(FeatStd_Diagnostics_LocationInfo_h)
#define FeatStd_Diagnostics_LocationInfo_h

#include <FeatStd/Base.h>

#include <FeatStd/Platform/Diagnostic.h>

namespace FeatStd { namespace Diagnostics {
/// @addtogroup FEATSTD_DIAGNOSTICS
/// @{
#if !defined(FEATSTD_LOG_FUNC)
    #error Must be defined in DiagnosticPlatform
#endif

#if defined(FEATSTD_LOG_LOCATION)
    #error Must not be defined outside
#endif
/// Creates LocationInfo object from current location.
/// @remarks Used by FEATSTD_LOG macro.
#define FEATSTD_LOG_LOCATION FeatStd::Diagnostics::LocationInfo(FEATSTD__FILE__, __LINE__, \
                                                                FEATSTD_LOG_FUNC)

/**
 * This class represents the location of a logging statement.
 * @remarks Used by FEATSTD_LOG_LOCATION to generate location info.
 * @attention Class holds only pointers to member strings!
 *            This means that CTOR parameters must exist as long as instance exists!
 */
struct LocationInfo
{
public:
    LocationInfo(const Char* fileName, Int lineNumber, const Char* methodName);
    ~LocationInfo();

    const Char*const mFullFileName; ///< Includes path
    const Char*const mFileName;     ///< Short name
    const Int        mLineNumber;
    const Char*const mFullMethodName; ///< Includes namespace and path
    const Char*const mMethodName;     ///< Plain method name

private:
    FEATSTD_MAKE_CLASS_UNCOPYABLE(LocationInfo);

    /// Returns (pointer to) short name of file.
    const Char* ExtractFileName() const;

    /// Returns (pointer to) plain name of method.
    const Char* ExtractMethodName() const;
};
/// @}
}}
#endif
