//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(FeatStd_Diagnostics_ErrorHandlingControl_h)
#define FeatStd_Diagnostics_ErrorHandlingControl_h

#include <FeatStd/Base.h>

namespace FeatStd { namespace Diagnostics {
/// @addtogroup FEATSTD_DIAGNOSTICS
/// @{
class IErrorHandlingControlHook;

/**
 * Main class for "unexpected error" handling functionality.
 * Functionality is mainly used from ErrorHandling.h.
 */
class ErrorHandlingControl
{
public:
    /**
     * Terminates program execution.
     * @param expression Expression evaluated in FEATSTD_PANIC_IF or
     *                   true in case of FEATSTD_PANIC.
     * @param filename   Location of calling FEATSTD_PANIC[_IF].
     * @param lineNr     Location of calling FEATSTD_PANIC[_IF].
     * @param info       User message.
     */
    //lint -function(abort, FeatStd::Diagnostics::ErrorHandlingControl::Panic)
    FEATSTD_LINT_NEXT_EXPRESSION(1916, "exceptional allowance for the ellipsis in error handling and logging. Logging is not part of production code.")
    static void Panic(const Char* expression,
                      const Char* filename, Int lineNr,
                      const Char* info, ...);

    /**
     * Sets hook to overwrite default behavior.
     * @param hookObject New hook object.
     * @returns previous hook object.
     */
    static IErrorHandlingControlHook* SetHook(IErrorHandlingControlHook* hookObject);

private:
    static IErrorHandlingControlHook* mHookObject;

    FEATSTD_MAKE_CLASS_STATIC(ErrorHandlingControl);
};

/**
 * Interface for hook object implementation.
 */
class IErrorHandlingControlHook
{
public:
    /**
     * Method to be called instead of default behaviour in ErrorHandlingControl::Panic.
     * @param expression Expression evaluated in FEATSTD_PANIC_IF.
     */
    virtual void HookMethod(const Char* expression) = 0;

    /**
    * Destructs an IErrorHandlingControlHook object.
    */
    virtual ~IErrorHandlingControlHook() {}
};
/// @}
}}

#endif
