//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "ErrorHandlingControl.h"
#include <FeatStd/Diagnostics/Debug.h>

#include <FeatStd/Util/CharBuffer.h>
#include <FeatStd/Platform/Diagnostic.h>
#include <FeatStd/Platform/VarArg.h>

namespace FeatStd { namespace Diagnostics {

using FeatStd::Internal::CharBuffer;

IErrorHandlingControlHook* ErrorHandlingControl::mHookObject = 0;

FEATSTD_LINT_NEXT_EXPRESSION(1916, "exceptional allowance for the ellipsis in error handling and logging. Logging is not part of production code.")
void ErrorHandlingControl::Panic(const Char* expression,
                                 const Char* filename, Int lineNr,
                                 const Char* info, ...)
{
    FEATSTD_DEBUG_ASSERT(expression != 0);
    FEATSTD_DEBUG_ASSERT(filename != 0);
    FEATSTD_DEBUG_ASSERT(info != 0);

    { // TODO Synchronize
        static CharBuffer<1000> lAssembledInfo;
        FEATSTD_VALIST lArgs;
        FEATSTD_VASTART(lArgs, info);
        lAssembledInfo.Format(info, lArgs);

        FEATSTD_LINT_NEXT_EXPRESSION(1924, "5-2-4 this cast warning is caused by system includes")
        FEATSTD_VAEND(lArgs);
        FEATSTD_UNUSED(lArgs);  // MISRA

        FEATSTD_DEBUG_ASSERT(lAssembledInfo.Length() >=  3);
        FEATSTD_DEBUG_ASSERT(lAssembledInfo.Length() < lAssembledInfo.Capacity());
        FEATSTD_DEBUG_ASSERT(lAssembledInfo.Length() <= 90);

        static CharBuffer<1000> lOutput;
        lOutput.Format("%s(%d): %s %s %s\n",
                       filename, lineNr,
                       "PANIC",
                       expression,
                       lAssembledInfo.c_str());
        FEATSTD_DEBUG_ASSERT(lOutput.Length() >=  20);
        FEATSTD_DEBUG_ASSERT(lOutput.Length() < lOutput.Capacity());
        FEATSTD_DEBUG_ASSERT(lOutput.Length() <= 500);

        if (mHookObject != 0) {
            mHookObject->HookMethod(lOutput.c_str());
        }

        FeatStd::Internal::Diagnostic::Panic(lOutput.c_str());
    }
    // Previous code must not return.
    FEATSTD_DEBUG_FAIL();
}

IErrorHandlingControlHook* ErrorHandlingControl::SetHook(IErrorHandlingControlHook* hookObject)
{
    IErrorHandlingControlHook*const lOldHookObject(mHookObject);
    mHookObject = hookObject;
    return lOldHookObject;
}
}}
