//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(FeatStd_Diagnostics_ErrorHandling_h)
#define FeatStd_Diagnostics_ErrorHandling_h

#include <FeatStd/Base.h>

#include "ErrorHandlingControl.h"

/// @addtogroup FEATSTD_DIAGNOSTICS
/// @{
/**
 * Terminates program execution.
 */
FEATSTD_LINT_MACRO_WHILEFALSE(FEATSTD_PANIC)
#define FEATSTD_PANIC(args, ...) \
    do { \
        FeatStd::Diagnostics::ErrorHandlingControl::Panic("true", \
                                                          FEATSTD__FILE__, __LINE__, \
                                                          args, ## __VA_ARGS__); \
    FEATSTD_SUPPRESS_MSC_WARNING_FOR_NEXT_EXPRESSION(4127, while (false) accepted) \
    } while (false)

/**
 * Terminates program execution in case of condition equals true.
 */
FEATSTD_LINT_MACRO_WHILEFALSE(FEATSTD_PANIC_IF)
#define FEATSTD_PANIC_IF(condition, args, ...) \
    do { \
        if ((condition)) { \
            FeatStd::Diagnostics::ErrorHandlingControl::Panic(#condition, \
                                                              FEATSTD__FILE__, __LINE__, \
                                                              args, ## __VA_ARGS__); \
        } \
    FEATSTD_SUPPRESS_MSC_WARNING_FOR_NEXT_EXPRESSION(4127, while (false) accepted) \
    } while (false)
/// @}
#endif
