//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include <FeatStd/Base.h>

#include "SystemMemoryStatistic.h"
#include <FeatStd/Platform/Diagnostic.h>

namespace FeatStd { namespace Diagnostics {
void DebuggerOutSystemMemoryStatistic(void*)
{
    SizeType count = SystemMemoryStatistic::GetAllocationCount();
    SizeType sum = 0;

    FeatStd::Internal::Diagnostic::DebuggerOut("---------- DebuggerOutSystemMemoryStatistic begin ----------\n");
    for (SizeType i = 0; i < count; i++) {
        const SystemMemoryStatistic::AllocationInfo* info = SystemMemoryStatistic::GetAllocationInfo(i);
        FeatStd::Internal::Diagnostic::DebuggerOut("%s(%d) : 0x%08X, %d bytes\n",
#if defined(FEATSTD_SYSTEM_MEMORY_STATISTIC_FILE_AND_LINE_TRACKING_ENABLED)
                                                                        info->m_fileName, info->m_line,
#else
                                                                        "", 0,
#endif
                                                                        info->m_userData, info->m_size);
        sum += info->m_size;
    }
    FeatStd::Internal::Diagnostic::DebuggerOut("Sum: %d bytes in %d blocks.\n", sum, count);
    FeatStd::Internal::Diagnostic::DebuggerOut("Peak: %d bytes.\n", SystemMemoryStatistic::GetPeakMemoryUsage());
    FeatStd::Internal::Diagnostic::DebuggerOut("---------- DebuggerOutSystemMemoryStatistic end   ----------\n");
}
}}
