//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "DebugControl.h"
#include <FeatStd/Diagnostics/Debug.h>
#include <FeatStd/Util/WarningMacros.h>

FEATSTD_LINT_CURRENT_SCOPE(766, "headers used for debug builds")

#if defined(FEATSTD_DEBUG)

#include <FeatStd/Platform/Diagnostic.h>
#if defined(FEATSTD_THREADSAFETY_ENABLED)
    #include <FeatStd/Platform/CriticalSectionLocker.h>
#endif

namespace FeatStd {
    namespace Diagnostics {

IDebugControlHook* DebugControl::mHookObject = 0;

bool DebugControl::Assert(const Char* expression, const Char* filename, Int lineNr)
{
#if defined(FEATSTD_THREADSAFETY_ENABLED)
    // Lock against concurrent calls from various threads
    static FeatStd::Internal::CriticalSection lLockObj;
    FeatStd::Internal::CriticalSectionLocker lLock(&lLockObj);
#endif

    if (mHookObject != 0) {
        mHookObject->HookMethod(expression);
        return false;
    }

    return FeatStd::Internal::Diagnostic::Assert(expression, filename, lineNr);
}

IDebugControlHook* DebugControl::SetHook(IDebugControlHook* hookObject)
{
    IDebugControlHook*const lOldHookObject(mHookObject);
    mHookObject = hookObject;
    return lOldHookObject;
}

ReentranceGuard::ReentranceGuard(UInt32& entryCount) : mEntryCount(entryCount)
{
    FEATSTD_DEBUG_ASSERT(mEntryCount == 0);

    mEntryCount++;
}

    }   // namespace Diagnostics
}   // namespace FeatStd
#else
#if defined(_MSC_VER)
namespace FeatStd {
    namespace Diagnostics {
        namespace {
            Char DebugControl_dummy; // avoid LNK4221
        }
    }
}
#endif    
#endif
