//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(FeatStd_Diagnostics_ConsoleAppender_h)
#define FeatStd_Diagnostics_ConsoleAppender_h

#include <FeatStd/Base.h>
#ifndef FEATSTD_LOG_ENABLED
    #error Feature FEATSTD_LOG_ENABLED is not enabled. Do not include any FeatStd logging releated header files!
#endif

#include "Appender.h"

namespace FeatStd { namespace Diagnostics {
/// @addtogroup FEATSTD_DIAGNOSTICS
/// @{
/**
 * Appends log events to stdout.
 * In case of Win32, log events are written using OutputDebugString also.
 * @remark Singleton pattern used to ensure the uniqueness of Console.
 */
class ConsoleAppender : public Appender
{
    typedef Appender Base;

    public:
        virtual ~ConsoleAppender();

        /**
         *  Returns singleton instance.
         *  @return The singleton instance.
         */
        static ConsoleAppender& GetInstance();

    protected:
        ConsoleAppender();

        virtual void DoAppend(const LogEvent& logEvent);
};
/// @}
}}
#endif
