//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "ConsoleAppender.h"

#include <FeatStd/Util/StaticObject.h>
#include "LogEvent.h"
#include "LocationInfo.h"

#include <FeatStd/Util/CharBuffer.h>
#include <FeatStd/Platform/Diagnostic.h>
#include <FeatStd/Config.h>

namespace FeatStd { namespace Diagnostics {

using FeatStd::Internal::CharBuffer;
using FeatStd::Internal::Diagnostic;

ConsoleAppender::ConsoleAppender() : Base()
{
}

ConsoleAppender::~ConsoleAppender()
{
}

/******************************************************************************
 *  GetInstance
 ******************************************************************************/
ConsoleAppender& ConsoleAppender::GetInstance()
{
    FEATSTD_UNSYNCED_STATIC_OBJECT(ConsoleAppender, s_instance);
    return s_instance;
}

static ConsoleAppender& s_forceInitInstance = ConsoleAppender::GetInstance();

/**
 * @remark Uses inherited char buffer!
 * @remark In case of DebuggerOut not supported or not IsDebuggerPresent(),
 *         2nd sprintf is wasted time :-((
 *
 * Following format is used:
 *      "time [threadId] level realm message {file(line): function}"
 */
void ConsoleAppender::DoAppend(const LogEvent& logEvent)
{
    typedef unsigned int MisraUInt;
    Diagnostic::ConsoleOut("%07d.%03d [0x%08x] %-5s %-13s %s {%s(%d): %s}\n",
                           (logEvent.mTimeStamp / 1000),
                           (logEvent.mTimeStamp % 1000),
                           static_cast<MisraUInt>(logEvent.mThreadId),
                           AsCStr(logEvent.mLogLevel),
                           logEvent.mLogRealmName,
                           logEvent.mMessage,
                           logEvent.mLocation.mFileName,
                           logEvent.mLocation.mLineNumber,
                           logEvent.mLocation.mMethodName);

#ifdef _MSC_VER
    // Following format is used:
    //      "     file(line)"
    //      "time [threadId] level realm message {function}"
    const UInt32 lMessageLength(FEATSTD_LOGGER_MAX_BUFFER_SIZE); // Includes \0!
    static CharBuffer<lMessageLength> lCharBuffer;
    lCharBuffer.Format("\t%s(%d)\n%07d.%03d [0x%08x] %-5s %-13s %s {%s}\n",
                       logEvent.mLocation.mFullFileName,
                       logEvent.mLocation.mLineNumber,
                       (logEvent.mTimeStamp / 1000),
                       (logEvent.mTimeStamp % 1000),
                       static_cast<MisraUInt>(logEvent.mThreadId),
                       AsCStr(logEvent.mLogLevel),
                       logEvent.mLogRealmName,
                       logEvent.mMessage,
                       logEvent.mLocation.mMethodName);
    FEATSTD_DEBUG_ASSERT(lCharBuffer.Length() >= 75);
    FEATSTD_DEBUG_ASSERT(lCharBuffer.Length() < lCharBuffer.Capacity());

    Diagnostic::DebuggerOut(lCharBuffer.c_str());
#endif
}
}}
