//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################


#if !defined(FeatStd_Diagnostics_CodeChecks_h)
#define FeatStd_Diagnostics_CodeChecks_h

#include <FeatStd/Platform/Diagnostic.h>

#if defined(FEATSTD_DEBUG)
#define FEATSTD_GUARD(condition) \
     if (!(condition)) { \
         if (FeatStd::Diagnostics::DebugControl::Assert((#condition), \
                                                         FEATSTD__FILE__, __LINE__)) { \
             FEATSTD_OS_BREAK(); \
         } \
     } else
#else
#define FEATSTD_GUARD(condition) \
    if (!(condition)) { } else
#endif

#endif
