//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "ViewController.h"
#include "VisualizationMsgs.h"

namespace Courier {
// ------------------------------------------------------------------------
ViewController::ViewController() : mView(0)
{
}

// ------------------------------------------------------------------------
ViewController::~ViewController()
{
    mView = 0;
}

// ------------------------------------------------------------------------
Message::ScopeMask ViewController::GetScopeMask() const
{
    return 0xFFFFFFFF;
}

// ------------------------------------------------------------------------
void ViewController::SetView(View * view)
{
    FEATSTD_PANIC_IF(mView!=0, "instance already in use");
    mView = view;
}

// ------------------------------------------------------------------------
void ViewController::ReleaseView()
{
    mView = 0;
}

// ------------------------------------------------------------------------
void ViewController::OnParentViewLoad(bool load)
{
    FEATSTD_UNUSED(load);
}

// ------------------------------------------------------------------------
void ViewController::OnParentViewActivate(bool activate)
{
    FEATSTD_UNUSED(activate);
}

// ------------------------------------------------------------------------
void ViewController::OnParentViewRenderingEnabled(bool enable)
{
    FEATSTD_UNUSED(enable);
}

// ------------------------------------------------------------------------
void ViewController::DispatchEvent(const Message & msg)
{
    switch(msg.GetId()) {
        case ParentViewActivateEvent::ID: {
            bool activated = Courier::message_cast<const ParentViewActivateEvent*>(&msg)->GetActivated();
            OnParentViewActivate(activated);
            break;
        }
        case ParentViewRenderingEnabledEvent::ID: {
            bool enabled = Courier::message_cast<const ParentViewRenderingEnabledEvent*>(&msg)->GetEnabled();
            OnParentViewRenderingEnabled(enabled);
            break;
        }
        case ParentViewLoadEvent::ID: {
            bool loaded = Courier::message_cast<const ParentViewLoadEvent*>(&msg)->GetLoaded();
            OnParentViewLoad(loaded);
            break;
        }
        default: {
            // garantuee to fall through !
        }
    }
    bool rc = OnMessage(msg);
    FEATSTD_UNUSED(rc);
}
}
