//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Courier_Foundation_ViewComponent_h)
#define Courier_Foundation_ViewComponent_h

#include <Courier/Foundation/Component.h>

#include <Courier/Visualization/ViewFacade.h>

// Forward declarations
namespace Courier {
    class Message;
    class IViewHandler;
    class ViewFactory;
}

namespace Courier {
    /// @addtogroup COURIER_FOUNDATION
    /// @{
    /** The ViewComponent is the instance which is maintaining the view tree structure.
        It uses the ViewFacade for creating, removing, activating etc. of views.
        It is not necessary to derive from this class. Functionality will be usually implemented
        in ViewController(s) and FrameworkWidget(s).
    */
    class ViewComponent : public Component {
    public:
        ///
        ViewComponent();

        ///
        virtual ~ViewComponent();

        /** Initializes the ViewComponent.
            @param viewHandler IViewHandler used for rendering and message distribution.
            @return <em>true</em> if initialization was successful,
                    <em>false</em> otherwise. */
        bool Init(IViewHandler * viewHandler);

    protected:
        /// Calls the Update method of the ViewFacade and therefore the Updated methods of the widgets.
        virtual bool OnExecute();

        /// Delegates view specific messages to the ViewFacade. 
        virtual bool OnMessage(const Message & msg);

    private:
        /// Delegates view related functionality.
        ViewFacade mViewFacade;
    };
    /// @}
}

#endif
