//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Courier_Visualization_RenderingMonitor_h)
#define Courier_Visualization_RenderingMonitor_h

#include <Candera/Candera.h>
#include <Courier/Util/Util.h>

#if defined(COURIER_RENDERING_MONITOR_ENABLED)

#include <Candera/System/Diagnostics/VideoMemoryStatistic.h>
#include <Candera/System/Monitor/PerfMonPublicIF.h>
#include <Candera/System/Monitor/MonitorPublicIF.h>

#include <PerfDataPlatform.h>

#include <CanderaMonitor/Util/BinaryWriter.h>
#include <CanderaMonitor/Util/BinaryReader.h>

#ifdef CANDERA_3D_ENABLED
    #include <Candera/System/Monitor/GlobalExperimentPublicIF.h>
    #include <CanderaMonitor/Measurement/RenderBenchmarkMeasurement.h>
    #include <CanderaMonitor/Util/Asset3dSerializer.h>
#endif 

FEATSTD_LINT_FILE(829, time.h, "maintained for backward compatibility")
#include <time.h>
#include <CanderaPlatform/Device/Common/Base/GpuPerformanceDataProvider.h>
#include <DevicePackageInterface.h>

namespace Courier { 
    class RenderHint;
}

namespace Courier { 
/// @addtogroup COURIER_VISUALIZATION
/// @{
/** The RenderingMonitor is used for monitoring rendering measurements.
    It is optional and be set via the SetRenderingMonitor of the ViewHandler. 
    FEATSTD_MONITOR_ENABLED has to be set in the configuration files to use CGI Analyzer.    
    By overwritting the virtual methods this class can be customized.
*/
class RenderingMonitor
{
    public:
        ///
        RenderingMonitor();
        
        ///
        virtual ~RenderingMonitor();
        
        /** Initializes the RenderingMonitor instance.
            @param ipAddr the IP address where CGI Analyzer is running.
            @param port the port number of CGI Analyzer to be connected to.
            @return <em>true</em> on success,
                    <em>false</em> otherwise. */
        FEATSTD_LINT_NEXT_EXPRESSION(1735, "intended default parameter for virtual function")
        virtual bool Init(const Char * ipAddr = "0.0.0.0", const Char * port = "13047");

        /// Frees resources.
        virtual void Finalize();

        /// Is called before render call has been started.
        virtual void OnRenderBegin();

        /// Is called after rendering has been finished.
        virtual void OnRenderEnd();
};

/// @}
}

#endif

#endif
