//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Courier_Visualization_ItemId_h)
#define Courier_Visualization_ItemId_h

#include <Courier/Util/FixedSizeString.h>
#include <Courier/Util/HashId.h>
#include <FeatStd/Platform/String.h>
#include <FeatStd/Util/StringBuffer.h>

// ----------------------------------------------------------------------------
namespace Courier { 
/// @addtogroup COURIER_VISUALIZATION
/// @{
/** An ItemId represents the Id of an item.
    It represents a constant character pointer and an hashvalue.
    It does not manage any memory.
*/
class ItemId 
{
    public:
        ///
        ItemId();

        ///
        explicit ItemId(const Char * itemString);

        ///
        ItemId(const ItemId & itemId);

        ///
        bool operator==(const ItemId & id) const {
            return id.mHashId==mHashId;
        }
        ///
        bool operator!=(const ItemId & id) const {
            return id.mHashId!=mHashId;
        }
        ///
        bool operator>(const ItemId & id) const {
            return FeatStd::Internal::String::CompareStrings(mId,id.mId)>0;
        }
        ///
        bool operator<(const ItemId & id) const {
            return FeatStd::Internal::String::CompareStrings(mId,id.mId)<0;
        }
        ///
        const Char * CStr() const {
            return mId;
        }
        ///
        const HashId GetHashId() const {
            return mHashId;
        }

    private:
        ///
        const Char * mId;
        ///
        HashId mHashId;
};

/// @}
}

#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
namespace FeatStd {
    template<> UInt32 StringBufferAppender<Courier::ItemId>::Append(StringBuffer& stringBuffer, Courier::ItemId const & object);
}
#endif
#endif
