//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Courier_Visualization_InvalidationViews_h)
#define Courier_Visualization_InvalidationViews_h

#include <Candera/Candera.h>
#ifdef FEATSTD_THREADSAFETY_ENABLED
#include <FeatStd/Platform/CriticalSection.h>
#endif
#include <Courier/Base.h>
#include <Courier/Util/Vector.h>
#include <Courier/Visualization/ViewId.h>
namespace Courier {
    namespace Internal {

        class InvalidationViews {
        public:
            static InvalidationViews& GetInstance();

            FeatStd::Internal::Vector<ViewId>& Swap();

            void Add(const ViewId& viewId);

            bool ContainsUnhandledViews();

        private:
            FeatStd::Initialized<FeatStd::SizeType> m_current;
            FeatStd::Internal::Vector<ViewId> m_views[2];
#ifdef FEATSTD_THREADSAFETY_ENABLED
            FeatStd::Internal::CriticalSection m_criticalSection;
#endif
        };

    }
}

#endif //Courier_Visualization_InvalidationViews_h
