//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Courier_Visualization_IViewHandler_h)
#define Courier_Visualization_IViewHandler_h

#include <Candera/Candera.h>
#include <CanderaPlatform/Device/Common/Base/RenderTarget.h>
#ifdef CANDERA_TRANSITIONS_ENABLED
#include <CanderaTransitions/Request.h>
#endif
namespace Candera {
    class ContentLoader;
    class AssetProvider;
    class AssetConfig;
}

#include <Courier/Visualization/ItemId.h>
#include <Courier/Visualization/VisualizationTypes.h>
#ifdef CANDERA_TRANSITIONS_ENABLED
#include <Courier/Transitions/TransitionTypes.h>
#endif
#include <Courier/Util/FixedSizeString.h>
#include <FeatStd/Util/Optional.h>

namespace Courier {
    class View;
    class FrameworkWidget;
    class Message;
    class ViewFactory;
    class AssetConfiguration;
    class Renderer;
    class ViewId;
    class CompositePath;
    class RenderHint;
    class AnimationProperties;
    class AssetProvider;
    class CameraGroupHandler;
    class ViewScene;
    class ViewVisitor;
}

namespace Courier {
    /** @addtogroup COURIER_VISUALIZATION
    * @{
    */

#if !defined(COURIER_DEFAULT_MAX_PAYLOADLENGTH)
    static const FeatStd::SizeType cCOURIER_DEFAULT_MAX_PAYLOADLENGTH = 64;
    #define COURIER_DEFAULT_MAX_PAYLOADLENGTH Courier::cCOURIER_DEFAULT_MAX_PAYLOADLENGTH
#else
    static const FeatStd::SizeType cCOURIER_DEFAULT_MAX_PAYLOADLENGTH = COURIER_DEFAULT_MAX_PAYLOADLENGTH;
#endif
    /** */
    typedef Courier::FixedSizeString<cCOURIER_DEFAULT_MAX_PAYLOADLENGTH> Payload;

    /** Touch information which is used for detection of a touched widget.
    */
    struct TouchInfo {
        TouchInfo(FeatStd::Int32 x, FeatStd::Int32 y, FeatStd::SizeType timestamp, UInt8 pointerId, FeatStd::SizeType sourceId) :
            mX(x),
            mY(y),
            mTimestamp(timestamp),
            mPointerId(pointerId),
            mSourceId(sourceId)
        {
        }

        TouchInfo(const TouchInfo & info) :
            mX(info.mX),
            mY(info.mY),
            mTimestamp(info.mTimestamp),
            mPointerId(info.mPointerId),
            mSourceId(info.mSourceId)
        {
        }

        FeatStd::Int32 mX;
        FeatStd::Int32 mY;
        FeatStd::SizeType mTimestamp;
        UInt8 mPointerId;
        FeatStd::SizeType mSourceId;
    };

    /** IViewHandler is the main abstract interface to the Candera functionality. */
    class IViewHandler
    {
    public:

        /** */
        virtual void Finalize() = 0;
        /** */
        virtual bool Init(ViewFactory * viewFactory, Candera::AssetConfig * assetConfiguration, Renderer * renderer, const Char * rootPath) = 0;
        /** */
        virtual bool Init(ViewFactory * viewFactory, Candera::AssetConfig * assetConfiguration, Renderer * renderer) = 0;
        /** */
        virtual bool Render(RenderHint * renderHint, bool renderAll) = 0;
        /** */
        virtual bool Render(RenderHint * renderHint) = 0;
        /** */
        virtual void Update(RenderHint * renderHint) = 0;
        /** */
        virtual bool PartialLoad() { return false; }
        /** */
        virtual bool OnMessage(const Message & msg) = 0;

        /** */
        virtual bool ExecuteAnimationAction(AnimationAction::Enum action, const ViewId & viewId, const CompositePath & compositePath, const ItemId & animationId, const AnimationProperties & properties) = 0;
        /** */
        virtual bool ExecuteViewAction(ViewAction::Enum action, const ViewId & viewId, bool loadScene, bool initScene) = 0;
        /** */
        virtual bool ExecuteTransitionAction(TransitionAction::Enum action, const ItemId & transitionId,
            const ViewId & firstViewId, const ViewId & secondViewId, const Payload & optionalPayload) = 0;
#ifdef CANDERA_TRANSITIONS_ENABLED
        /** */
        virtual bool ExecuteCanderaTransitionReqAction(CanderaTransitionRequestAction::Enum,
                                               const Candera::Transitions::Identifier&,
                                               const Candera::Transitions::Hint&) { return false; };
        /** */
        virtual bool ExecuteCanderaTransitionControlFlowAction(CanderaTransitionControlFlowAction::Enum) { return false; };
#endif
        /** */
        virtual bool ChangeTheme(const ItemId & themeId) = 0;
        /** */
        virtual Candera::ContentLoader * GetContentLoader() = 0;
        /** */
        virtual Candera::AssetProvider * GetAssetProvider() = 0;
        /** */
        virtual Candera::Animation::AnimationTimeDispatcher * GetAnimationTimeDispatcher() = 0;
        /** */
        virtual Candera::Animation::AnimationTimeDispatcher::SharedPointer GetAnimationTimeDispatcherSharedPointer() = 0;
        /** */
        FEATSTD_LINT_NEXT_EXPRESSION(1735,"Virtual function does not override a base-class function.")
            virtual void Invalidate(Candera::RenderTarget * renderTarget, const FeatStd::Optional<Candera::Rectangle>& dirtyArea = FeatStd::Optional<Candera::Rectangle>()) = 0;
        /** */
        FEATSTD_LINT_NEXT_EXPRESSION(1735,"Virtual function does not override a base-class function.")
            virtual void InvalidateAll(bool forceInvalidateAllRendertargets, const FeatStd::Optional<Candera::Rectangle>& dirtyArea = FeatStd::Optional<Candera::Rectangle>()) = 0;
        /** */
        virtual bool ActivateLayer(Int layerId, bool activate) = 0;
        /** */
        virtual void DestroyView(Courier::View * view) = 0;
        /** */
        virtual View * FindView(const ViewId & viewId) = 0;

        /** */
        virtual FrameworkWidget * FindWidget(const ViewId & viewId, const CompositePath & compositePath, const ItemId & widgetId) = 0;

        /** */
        virtual bool SetWidgetProperty(const ViewId & viewId, const CompositePath & compositePath, const ItemId & widgetId, const ItemId & propertyId, const Char * value) = 0;

        /** */
        virtual bool SetFocus(const ViewId & viewId, const CompositePath & compositePath, const ItemId & widgetId) = 0;
        /** */
        virtual bool SetFocus(FrameworkWidget* frameworkWidget) = 0;
        /** */
        virtual bool LoseFocus(FrameworkWidget * widget) = 0;
        /** */
        virtual bool AddAnimationPlayer(Candera::MemoryManagement::SharedPointer<Candera::Animation::AnimationPlayerBase> player) = 0;
        /** */
        virtual void RemoveAnimationPlayer(Candera::MemoryManagement::SharedPointer<Candera::Animation::AnimationPlayerBase> player) = 0;
        /** */
        virtual Renderer * GetRenderer() = 0;
        /** */
        virtual bool SetCurrentCulture(const Char * ) { return false; }
        /** */
        virtual void Accept(ViewVisitor* visitor) = 0;
        /** */
        virtual CameraGroupHandler * GetCameraGroupHandler() { return 0; }
        /** */
        virtual bool OnMessageViewTreeOnly(const Message & ) { return false; }

        COURIER_DEPRECATED_MSG("DEPRECATED! - Please use SchedulePartialLoad instead")
            virtual bool SetCurrentLoadingViewScene(ViewScene * viewScene, bool forceUpload) { return SetCurrentLoadingViewSceneInternal(viewScene, forceUpload); };

        COURIER_DEPRECATED_MSG("DEPRECATED! - Please use SchedulePartialLoad instead")
            virtual ViewScene * GetCurrentLoadingViewScene() { return GetCurrentLoadingViewSceneInternal(); };

        /** */
        virtual void SchedulePartialLoad(Courier::ViewScene * view, bool forceUpload) = 0;

    private:
        virtual bool SetCurrentLoadingViewSceneInternal(ViewScene *, bool) {return false; }
        virtual ViewScene * GetCurrentLoadingViewSceneInternal() { return 0; }
    };

    /** @} */
}

#endif
