//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "CompositePath.h"
#include <Courier/Diagnostics/ErrorHandling.h>

namespace Courier {
// ------------------------------------------------------------------------
CompositePath::CompositePath() :
    mIdentifierType(CStringType),
    mId(""),
    mHashId("")
{
}

// ------------------------------------------------------------------------
CompositePath::CompositePath(const Candera::StringIdentifier * stringIdentifier) :
    mIdentifierType(StringIdentifierType),
    mStringIdentifier(stringIdentifier),
    mHashId(stringIdentifier, true)
{
    if (0 == stringIdentifier) {
        mHashId = HashId("");
        mId = "";
        mIdentifierType = CStringType;
    }
}

// ------------------------------------------------------------------------
CompositePath::CompositePath(const Char * compositePathString) :
    mIdentifierType(CStringType),
    mId(compositePathString),
    mHashId(compositePathString)
{
    FEATSTD_PANIC_IF(compositePathString == 0, "string pointer zero !");
}

// ------------------------------------------------------------------------
CompositePath::CompositePath(const CompositePath & compositePath) :
    mIdentifierType(compositePath.mIdentifierType),
    mHashId(compositePath.mHashId)
{
    if (mIdentifierType == CStringType) {
        FEATSTD_LINT_NEXT_EXPRESSION(1554, "we want to copy the pointer")
        mId = compositePath.mId;
    }
    else {
        FEATSTD_LINT_NEXT_EXPRESSION(1554, "we want to copy the pointer")
        mStringIdentifier = compositePath.mStringIdentifier;
    }
}

}

#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
namespace FeatStd {

template<> UInt32 StringBufferAppender< Courier::CompositePath >::Append(StringBuffer& stringBuffer, Courier::CompositePath const & object)
{
    ::FeatStd::UInt32 tcharCount = 0;
    tcharCount += stringBuffer.Append("{");
    tcharCount += stringBuffer.Append("HashId = ");
    tcharCount += stringBuffer.AppendObject(object.GetHashId().HashValue());
    tcharCount += stringBuffer.Append(", ");
    tcharCount += stringBuffer.Append("IdentifierType = ");
    switch (object.GetIdentifierType()) {
    case Courier::CompositePath::StringIdentifierType:
        {
            tcharCount += stringBuffer.Append("::Courier::CompositePath::StringIdentifierType");
            break;
        }
    case Courier::CompositePath::CStringType:
        {
            tcharCount += stringBuffer.Append("::Courier::CompositePath::CStringType");
            break;
        }
    default:
        {
            tcharCount += stringBuffer.Append("##unknown##");
            break;
        }
    }
    tcharCount += stringBuffer.Append(" }");
    return tcharCount;
}

} //namespace FeatStd
#endif
