//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Courier_ComponentWakeupHelper_h)
#define Courier_ComponentWakeupHelper_h

#include <Courier/Messaging/MessagingMsgs.h>
#include <Courier/Messaging/MessageReferrer.h>
#include <Courier/Diagnostics/Log.h>
#include <FeatStd/Util/StaticObject.h>

namespace Courier {

    COURIER_LOG_SET_REALM(Courier::Diagnostics::LogRealm::Visualization);

namespace Internal {

template <ComponentId componentId>
class ComponentWakeupHelper
{
public:
    static bool Init() {
        void(GetTriggerComponentExecuteMsg());
        return true;
    }

    static void Wakeup()
    {
        Message* message = GetTriggerComponentExecuteMsg();
        bool rc = (0 != message) && message->Post();
        if (!rc) {
            COURIER_LOG_ERROR("TriggerComponentExecuteMsg for component %d could not be posted.", componentId);
        }
    }

private:
    static Message* GetTriggerComponentExecuteMsg()
    {
        FEATSTD_UNSYNCED_STATIC_OBJECT(MessageReferrer, s_messageReferrer, (COURIER_MESSAGE_NEW(TriggerComponentExecuteMsg)(componentId)));
        return s_messageReferrer.GetMessage();
    }
};

} // namespace Internal
} // namespace Courier
#endif
