//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Courier_Visualization_ClearingData3D_h)
#define Courier_Visualization_ClearingData3D_h

#include <Candera/Candera.h>
#include <Courier/Visualization/ClearingData.h>

#if defined(CANDERA_3D_ENABLED)

#include <Courier/Util/Vector.h>

/** @addtogroup COURIER_VISUALIZATION
 * @{
 */
/** A ClearingData3D is a data class holding clear cameras and clear scenes.
*/
namespace Courier {

    class Gdu;

    namespace Internal {

        typedef ClearingData<Candera::Camera, Candera::Scene> Base3D; 
        class ClearingData3D : public Base3D {
        public:
            FEATSTD_TYPEDEF_BASE(Base3D);

            ClearingData3D() {}

            ~ClearingData3D() {}

            virtual void Init(const Courier::Gdu* gdu);

            virtual void SetupClearCamera(const Candera::Camera *camera);
        };
    }
}
/** @} */
#endif //CANDERA_3D_ENABLED
#endif //Courier_Visualization_ClearingData3D_h
