//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "ClearingData3D.h"

#if defined(CANDERA_3D_ENABLED)

#include "VisualizationMsgs.h"
#include <FeatStd/MemoryManagement/Heap.h>
#include <Courier/Visualization/Gdu.h>

namespace Courier {
using namespace Candera;
using namespace Courier::Internal;

// ------------------------------------------------------------------------
void ClearingData3D::Init(const Gdu* gdu)
{
    if ((0 == mClearScene) || (0 == mClearCamera)) {
        Scene * clearScene = Scene::Create();
        Camera * clearCamera = Camera::Create();
        if (( 0 != clearScene) && (0 != clearCamera)) {
            if (clearScene->AddChild(clearCamera)) {
                RenderOrder * ro = RenderOrder::Create(1,1);
                if (0 != ro) {
                    clearCamera->SetRenderOrder(ro);
                    // Setup clear mode for clear camera
                    ClearMode cm;
                    static const Color clearColor(0.0F, 0.0F, 0.0F, 0.0F);
                    cm.SetClearColor(clearColor);
                    cm.SetColorClearEnabled(true);
                    clearCamera->SetClearMode(cm);

                    clearCamera->SetRenderingEnabled(false);

                    if (0 != gdu) {
                        RenderTarget3D * renderTarget3D = gdu->GetGdu()->ToRenderTarget3D();
                        if (0 != renderTarget3D) {
                            clearCamera->SetRenderTarget(renderTarget3D);
                            mClearScene = clearScene;
                            mClearCamera = clearCamera;
                        }
                    }
                }
            }
        }
        if ((0 == mClearScene) && (0 != clearScene)) {
            clearScene->Dispose();
        }
    }
}

void ClearingData3D::SetupClearCamera(const Candera::Camera* camera)
{
    mClearCamera->SetViewport(camera->GetViewport());

    mClearCamera->SetScissoringEnabled(camera->IsScissoringEnabled());
    mClearCamera->SetScissorRectangle(camera->GetScissorRectangle());
}

}
#endif //CANDERA_3D_ENABLED
