//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Courier_Visualization_ClearingData2D_h)
#define Courier_Visualization_ClearingData2D_h

#include <Courier/Visualization/ClearingData.h>
#include <Candera/Candera.h>

#if defined(CANDERA_2D_ENABLED)

#include <Courier/Util/Vector.h>


namespace Courier {

    class Gdu;

    namespace Internal {

        /// @addtogroup COURIER_VISUALIZATION
        // @{
        /** A ClearingData2D is a data class holding 2D clear cameras and clear scenes.
        */
        typedef ClearingData<Candera::Camera2D, Candera::Scene2D> Base2D; 
        class ClearingData2D : public Base2D {
        public:
            FEATSTD_TYPEDEF_BASE(Base2D);

            ClearingData2D() {}

            ~ClearingData2D() {}

            virtual void Init(const Courier::Gdu* gdu);
            virtual void Finalize();

            virtual void SetupClearCamera(const Candera::Camera2D *camera);
        };
    }
    /// @}
}

#endif //CANDERA_2D_ENABLED
#endif //Courier_Visualization_ClearingData2D_h
