//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "ClearingData2D.h"

#if defined(CANDERA_2D_ENABLED)

#include "IViewHandler.h"
#include "VisualizationMsgs.h"
#include <Courier/Visualization/Gdu.h>

namespace Courier {
using namespace Candera;
using namespace Courier::Internal;

// ------------------------------------------------------------------------
void ClearingData2D::Init(const Gdu* gdu)
{
    if ((0 == mClearScene) || (0 == mClearCamera)) {
        Scene2D * clearScene2D = Scene2D::Create();
        Camera2D * clearCamera2D = Camera2D::Create();
        if (( 0 != clearScene2D) && (0 != clearCamera2D)) {
            if (clearScene2D->AddChild(clearCamera2D)) {
                static const Color clearColor(0.0F, 0.0F, 0.0F, 0.0F);
                clearCamera2D->SetClearColor(clearColor);
                clearCamera2D->SetClearColorEnabled(true);
                clearCamera2D->SetRenderingEnabled(false);
                if (0 != gdu) {
                    RenderTarget2D* renderTarget2D = gdu->GetGdu()->ToRenderTarget2D();
                    if (0 != renderTarget2D) {
                        clearCamera2D->SetRenderTarget(renderTarget2D);
                        mClearScene = clearScene2D;
                        mClearCamera = clearCamera2D;
                    }
                }
            }
        }
        if ((0 == mClearScene) && (0 != clearScene2D)) {
            clearScene2D->Dispose();
        }
    }
}

// ------------------------------------------------------------------------
void ClearingData2D::Finalize()
{
    if (0 != mClearScene) {
        mClearScene->Dispose();
        mClearScene = 0;
        mClearCamera = 0;
    }
}

void ClearingData2D::SetupClearCamera(const Candera::Camera2D* camera)
{
    mClearCamera->SetViewport(camera->GetViewport());

    mClearCamera->SetScissoringEnabled(camera->IsScissoringEnabled());
    mClearCamera->SetScissorRectangle(camera->GetScissorRectangle());

    if (camera->IsClearColorEnabled())
    {
        // If scene camera has clear enabled, use the camera's clear color
        mClearCamera->SetClearColor(camera->GetClearColor());
    }
}
}
#endif //CANDERA_2D_ENABLED
