//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Courier_Visualization_ClearingData_h)
#define Courier_Visualization_ClearingData_h

#include <Candera/Candera.h>
#include <Courier/Util/Vector.h>

namespace Courier {

    class Gdu;

    namespace Internal {

        /// @addtogroup COURIER_VISUALIZATION
        // @{
        /** A ClearingData is a data class holding clear cameras and clear scenes.
        */
        template<class CameraType, class SceneType>
        class ClearingData {
        public:
            ClearingData():
                mClearCamera(static_cast<CameraType*>(0)),
                mClearScene(static_cast<SceneType*>(0)) {}

            virtual ~ClearingData() { ClearingData::Finalize(); }

            virtual void Init(const Courier::Gdu* gdu) = 0;

            virtual void Finalize()
            {
                if (0 != mClearScene) {
                    mClearScene->Dispose();
                    mClearScene = 0;
                    mClearCamera = 0;
                }
            }

            CameraType* GetClearCamera() { return mClearCamera;}
            SceneType* GetClearScene() { return mClearScene;}

            /// Set up clearing camera from an actual scene camera 
            /// @param camera A camera from the active scene
            virtual void SetupClearCamera(const CameraType *camera) = 0;

        protected:
            FEATSTD_MAKE_CLASS_UNCOPYABLE(ClearingData);

            CameraType* mClearCamera;
            SceneType* mClearScene;
        };

#if defined(CANDERA_2D_ENABLED)
        ///
        typedef Courier::Vector<ClearingData<Candera::Camera2D, Candera::Scene2D>*> ClearingData2DVct;
        typedef Candera::Internal::Map<Candera::Camera2D*, ClearingData<Candera::Camera2D, Candera::Scene2D>*> CameraToClearingData2D;
#endif

#if defined(CANDERA_3D_ENABLED)
        ///
        typedef Courier::Vector<ClearingData<Candera::Camera, Candera::Scene>*> ClearingData3DVct;
        typedef Candera::Internal::Map<Candera::Camera*, ClearingData<Candera::Camera, Candera::Scene>*> CameraToClearingData3D;
#endif

    }
    /// @}
}

#endif //Courier_Visualization_ClearingData_h
