//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Courier_Visualization_AsyncValidationWakeup_h)
#define Courier_Visualization_AsyncValidationWakeup_h

#include <Candera/Candera.h>

#include <Courier/Base.h>
#include <Courier/Util/Vector.h>

#include <Courier/Visualization/ViewScene2D.h>
#include <Courier/Visualization/ViewScene3D.h>
#include <Candera/TextEngine/Async/AsyncTextRenderDispatcher.h>
#include <Candera/TextEngine/Async/TextValidator.h>
#include <Candera/TextEngine/Async/TextValidationEventSources.h>
#include <Courier/Visualization/Renderer.h>

namespace Courier {
    namespace Internal {

        /** */
        class AsyncValidationWakeup : public FeatStd::EventListener {

        public:
            AsyncValidationWakeup();

            virtual ~AsyncValidationWakeup();

            virtual FeatStd::EventResult::Enum OnEvent(const FeatStd::Event& event) override;
#ifdef FEATSTD_THREADSAFETY_ENABLED
            FEATSTD_EVENTLISTENER_STANDARD_THREADSAFETY;
#endif
        };
    }
}

#endif // Courier_Visualization_AsyncValidationWakeup_h
