//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "AsyncValidationWakeup.h"

#include <Courier/Diagnostics/Log.h>
#include <Courier/Visualization/InvalidationViews.h>



namespace Courier {
    namespace Internal {

       COURIER_LOG_SET_REALM(Courier::Diagnostics::LogRealm::Visualization);

        
        AsyncValidationWakeup::AsyncValidationWakeup()
        {
            if (!Candera::TextRendering::Internal::TextValidationEventSources::GetDefaultValidationEventSource().AddEventListener(this)) {
                FEATSTD_LOG_ERROR("AsyncValidationWakeup were not able to add event listener to event source!");
            }
        }

        AsyncValidationWakeup::~AsyncValidationWakeup()
        {
            static_cast<void>(Candera::TextRendering::Internal::TextValidationEventSources::GetDefaultValidationEventSource().RemoveEventListener(this));
            FEATSTD_LINT_NEXT_EXPRESSION(1506, "This class shall not be derived from - The WaitForRelease is written to be called within the constructor and shall not be further overridden.")
            WaitForRelease();
            
        }
                
        FeatStd::EventResult::Enum AsyncValidationWakeup::OnEvent(const FeatStd::Event& event)
        {
            const Candera::TextRendering::Internal::Node2DValidationEvent* nodeEvent = FeatStd::Dynamic_Cast<const Candera::TextRendering::Internal::Node2DValidationEvent*>(&event);
            if (nodeEvent != 0) {
                Candera::Scene2D * scene = nodeEvent->GetNode2D()->GetScene();
                FEATSTD_DEBUG_ASSERT(scene != 0);
                if (scene != 0) {
                    const Char* sceneName = scene->GetName();
                    FEATSTD_DEBUG_ASSERT(sceneName != 0);
                    if (sceneName != 0) {
                        InvalidationViews::GetInstance().Add(ViewId(sceneName));
                    }
                }
            }
            else {
                const Candera::TextRendering::Internal::TriggerValidationUpdateEvent* triggerEvent = FeatStd::Dynamic_Cast<const Candera::TextRendering::Internal::TriggerValidationUpdateEvent*>(&event);
                FEATSTD_DEBUG_ASSERT(triggerEvent != 0);
                if (triggerEvent != 0) {
                    Courier::Renderer::WakeUpAllRenderComponents();
                }

            }
            return FeatStd::EventResult::Proceed;
        }
    }
}
