//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "AssetConfiguration.h"

namespace Courier {

#if ! defined(COURIER_DEFAULT_ASSETREPOSITORIES_COUNT)
    static const FeatStd::Int cCOURIER_DEFAULT_ASSETREPOSITORIES_COUNT = 8;
#else
    static const FeatStd::Int cCOURIER_DEFAULT_ASSETREPOSITORIES_COUNT = COURIER_DEFAULT_ASSETREPOSITORIES_COUNT;
#endif

// ------------------------------------------------------------------------
AssetConfiguration::AssetConfiguration()
{
    if(! mAssetRepositories.Reserve(cCOURIER_DEFAULT_ASSETREPOSITORIES_COUNT)) {
        FEATSTD_PANIC("Can't reserve memory for asset repositories pointers");
    }
}

// ------------------------------------------------------------------------
AssetConfiguration::~AssetConfiguration()
{
    Clear();
}

// ------------------------------------------------------------------------
void AssetConfiguration::Clear()
{
    mAssetRepositories.Clear();
}

// ------------------------------------------------------------------------
bool AssetConfiguration::Add(Candera::AssetRepository * repository)
{
    FEATSTD_DEBUG_ASSERT(repository!=0);
    if(repository!=0) {
        return mAssetRepositories.Add(repository);
    }
    return false;
}

// ------------------------------------------------------------------------
bool AssetConfiguration::Remove(const Candera::AssetRepository * repository)
{
    FEATSTD_DEBUG_ASSERT(repository!=0);
    if(repository!=0) {
        for(FeatStd::SizeType i=0; i<mAssetRepositories.Size(); i++) {
            if(mAssetRepositories[i]==repository) {
                return mAssetRepositories.Remove(i);
            }
        }
    }
    return false;
}

// ------------------------------------------------------------------------
Candera::AssetRepository * AssetConfiguration::GetAssetRepository(UInt16 index) const
{
    return mAssetRepositories[index];
}

// ------------------------------------------------------------------------
UInt16 AssetConfiguration::GetAssetRepositoryCount() const
{
    return static_cast<UInt16>(mAssetRepositories.Size());
}
}
