//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Courier_Visualization_AnimationProperties_h)
#define Courier_Visualization_AnimationProperties_h

#include <Candera/Candera.h>
#include <Candera/EngineBase/Animation/AnimationPlayer.h>

#include <Courier/Base.h>
#include <FeatStd/Util/StringBuffer.h>

namespace Courier {
    class View;
    class FrameworkWidget;
    class ViewFactory;
    class AssetConfiguration;
    class Renderer;
    class ViewId;
    class RenderHint;
}

namespace Courier {
/// @addtogroup COURIER_VISUALIZATION
/// @{
/** AnimationProperties can be used for setting animation start parameters.
    Only values which are moedified by a setter method will be also set to Candera animation object.
*/
    class AnimationProperties {
        public:
            /// Default Constructor
            AnimationProperties();

            /// Copy constructor.
            AnimationProperties(const AnimationProperties & properties);

            /// Valid for both AnimationPlayer and AnimationGroupPlayer, if AnimationAction::Start is used.
            void SetSpeedFactor(Float speedFactor) { mSpeedFactor = speedFactor; mWasSet.mSpeedFactor = true; }

            /// Valid for both AnimationPlayer and AnimationGroupPlayer, if AnimationAction::Start is used.
            void SetRepeatCount(UInt32 repeatCount) { mRepeatCount = repeatCount; mWasSet.mRepeatCount = true; }

            /// Valid for AnimationPlayer, if AnimationAction::Start is used.
            void SetSequenceStartTimeMs(Candera::Animation::SequenceTimeType ms) { mSequenceStartTimeMs = ms; mWasSet.mSequenceStartTimeMs = true; }

            /// Valid for AnimationPlayer, if AnimationAction::Start is used.
            void SetSequenceDurationMs(Candera::Animation::SequenceTimeType ms)  { mSequenceDurationMs = ms; mWasSet.mSequenceDurationMs = true; }

            /// Valid for AnimationPlayer, if AnimationAction::Start is used.
            void SetRepeatMode(Candera::Animation::AnimationPlayer::RepeatMode repeatMode) { mRepeatMode = repeatMode; mWasSet.mRepeatMode = true; }

            /// Valid for AnimationPlayer, if AnimationAction::Start is used.
            void SetDirection(Candera::Animation::AnimationPlayer::PlayDirection direction)  { mPlayDirection = direction; mWasSet.mPlayDirection = true; }

            /// Is used for jumping to the end of Animation.
            void RevertDirection() {
                if(mPlayDirection==Candera::Animation::AnimationPlayer::Forward) {
                    mPlayDirection = Candera::Animation::AnimationPlayer::Reverse;
                    mWasSet.mPlayDirection = true;
                } else if (mPlayDirection==Candera::Animation::AnimationPlayer::Reverse) {
                    mPlayDirection = Candera::Animation::AnimationPlayer::Forward;
                    mWasSet.mPlayDirection = true;
                } else {
                    // MISRA
                }
            }

            /// Valid for both AnimationPlayer and AnimationGroupPlayer, if AnimationAction::Finish is used.
            void SetTimeToFinish(UInt32 timeToFinish) { mTimeToFinish = timeToFinish; }
            UInt32 GetTimeToFinish() const { return mTimeToFinish; }

            ///
            void ApplyProperties(Candera::Animation::AnimationPlayer * singlePlayer) const;

            ///
            void ApplyProperties(Candera::Animation::AnimationPlayerBase * animationPlayerBase) const;

        private:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
            typedef FeatStd::StringBufferAppender<AnimationProperties> AnimationPropertiesStringBufferAppender;
            template<typename T> friend struct FeatStd::StringBufferAppender;
#endif
            Courier::Float mSpeedFactor;
            UInt32 mRepeatCount;
            UInt32 mTimeToFinish;
            Candera::Animation::SequenceTimeType mSequenceStartTimeMs;
            Candera::Animation::SequenceTimeType mSequenceDurationMs;
            Candera::Animation::AnimationPlayer::RepeatMode mRepeatMode;
            Candera::Animation::AnimationPlayer::PlayDirection mPlayDirection;
            struct SetMask {
                bool mSpeedFactor : 1;
                bool mRepeatCount : 1;
                bool mSequenceStartTimeMs : 1;
                bool mSequenceDurationMs : 1;
                bool mRepeatMode : 1;
                bool mPlayDirection : 1;
            } mWasSet;
    };
/// @}
}

#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
namespace FeatStd {
    template<> UInt32 StringBufferAppender< Candera::Animation::AnimationPlayer::PlayDirection >::Append(StringBuffer& stringBuffer, Candera::Animation::AnimationPlayer::PlayDirection const & object);
    template<> UInt32 StringBufferAppender< Candera::Animation::AnimationPlayer::RepeatMode >::Append(StringBuffer& stringBuffer, Candera::Animation::AnimationPlayer::RepeatMode const & object);
    template<> UInt32 StringBufferAppender< Courier::AnimationProperties >::Append(StringBuffer& stringBuffer, Courier::AnimationProperties const & object);
}
#endif
#endif
